class Ex3_11
parameter Real pi = Modelica.Constants.pi;
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real m_adot(unit="kg/s")=20;/*mass flow rate of air*/
parameter Real N(unit="r.p.m")=13000;/*speed of impeller*/
parameter Real p3_by_p1=3.5;/*pressure ratio with isentropic condition*/
parameter Real p3_das_by_p1=3.5;/*actual pressure ratio*/
parameter Real eta_ise=0.8;/*isentropic efficiency*/
parameter Real mu=0.9;/*slip factor*/
parameter Real Vf2_by_U2=0.35;/*flow coefficient at impeller exit*/
parameter Real d1(unit="m")=15/100;/*hub diameter of eye. Here d1 is divided by 100 to convert the unit from cm to m*/
parameter Real Vf1(unit="m/s")=150;/*axial velocity at entry of impeller vane*/
parameter Real Vf2(unit="m/s")=150;/*axial velocity at exit of impeller vane*/
parameter Real T01(unit="K")=295;/*stagnation temperature at inlet*/
parameter Real p01(unit="bar")=1;/*stagnation pressure at inlet*/

Real p1(unit="bar");/*static pressure at inlet of impeller*/
Real p2(unit="bar");/*static pressure at outlet of impeller*/
Real p3(unit="bar");/*static pressure at outlet of diffuser*/

Real U2(unit="m/s");/*tangential blade tip speed at outlet*/
Real D2(unit="m");/*outer diameter of impeller*/
Real V1(unit="m/s");/*absolute velocity at inlet*/

Real T1(unit="K");/*static temperature at inlet*/
Real rho_a1(unit="kg/m^3");/*density of eye of the impeller*/

Real D1(unit="m");/*diameter of eye of compressor impeller*/

Real T2(unit="K");/*static temperature at outlet with isentropic condition*/
Real T2_das(unit="K");/*actual static temperature at outlet*/

Real rho_a2(unit="kg/m^3");/*density of air at exit of the impeller*/

parameter Real K=1;/*blade area coefficient at inlet*/
Real b2(unit="m");/*height of impeller vane at outlet*/

Real theoretical_power(unit="W");/*theoretical power input*/

equation
U2=Vf2/Vf2_by_U2;
U2=(pi*D2*N)/60;
V1=Vf1;

T01=T1+V1^2/(2*C_p);
T01/T1=(p01/p1)^((gama-1)/gama);
(p1*10^5)/rho_a1=R*T1;/*here p1 has been multilied by 10^5 to convert the unit from bar to N/m^2*/

m_adot=rho_a1*(pi/4)*(D1^2-d1^2)*V1;

p3=p3_by_p1*p1;
p2/p1=p3/p2;

T2/T1=(p2/p1)^((gama-1)/gama);
eta_ise=(T2-T1)/(T2_das-T1);

(p2*10^5)/rho_a2=R*T2_das;/*here p2 has been multilied by 10^5 to convert the unit from bar to N/m^2*/

m_adot=rho_a2*K*pi*b2*D2*Vf2;

theoretical_power=m_adot*mu*U2^2;

/*The  answer may slightly vary due to  rounding off values. Also wrong answer of static pressure ratio is given in the book*/

end Ex3_11;
