class Ex3_3
parameter Real pi = Modelica.Constants.pi;
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real T1(unit="K")=300;/*static temperature at inlet*/
parameter Real N(unit="rpm")=20000;/*rotational speed of the compressor*/
parameter Real mu=0.85;/*slip factor*/
parameter Real phi_w=1.035;/*power input factor*/
parameter Real eta_ise=0.8;/*isentropic efficiency of the compressor*/
parameter Real D2(unit="m")=0.6;/*outer diameter of the blade tip*/

Real U2(unit="m/s");/*tangential velocity of inpeller vames at outlet*/

Real W_a(unit="J/kg");/*actual thermodynamic work of compressor*/

Real T2_das(unit="K");/*actual static head temperature at outlet*/
Real T2(unit="K");/*static head temperature at outlet for isentropic condition*/
Real T2_das_T1(unit="K");/*remperature riseof air through compressor*/
 
Real p2_by_p1;/*static head pressure ratio of the compressor*/

equation
U2=(pi*D2*N)/60;

W_a=phi_w*mu*U2^2;
W_a=C_p*(T2_das-T1);

T2_das_T1=T2_das-T1;

eta_ise=(T2-T1)/(T2_das-T1);

p2_by_p1=(T2/T1)^(gama/(gama-1));

/*The  answer may slightly vary due to  rounding off values*/
end Ex3_3;
