class Ex3_4
parameter Real pi = Modelica.Constants.pi;
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real m_adot(unit="kg/s")=6;/*free air delivered by the centrifugal compressor in kg/s*/
parameter Real V1(unit="m/s")=150;/*velocity of air at the eye of impeller*/
parameter Real p1(unit="bar")=1;/*static pressure at inlet*/

parameter Real T1_degC(unit="degC")=20;/*static temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*static temperature at inlet in degree kelvin unit*/

parameter Real V_w2das_by_U2=0.9;/*ratio of whirl speed to tip speed*/
parameter Real mu=0.9;/*slip factor*/
parameter Real phi_w=1;/*power input factor*/
parameter Real N(unit="rpm")=22000;/*rotational speed of the compressor*/
parameter Real eta_ise=0.82;/*isentropic efficiency of the compressor*/
parameter Real p02_p01=4.2;/*total head pressure ratio of the compressor*/

Real T01(unit="K");/*total head temperature at inlet*/
Real T02(unit="K");/*total head temperature of air at exit of compressor for isentropic condition*/
Real T02_das_T01(unit="K");/*rise in stagnation temperature from inlet to outlet*/

Real W_a(unit="J/kg");/*actual thermodynamic work required for compressor*/
Real P(unit="W");/*power required*/

Real U2(unit="m/s");/*tangential velocity of inpeller vames at outlet*/
Real D2(unit="m");/*impeller tip diameter*/

Real rho_a1(unit="kg/m^3");/*density of air at inlet*/
parameter Real d1(unit="m")=0.1;/*diameter of eye at eye*/
Real D1(unit="m");/*tip diameter of vane at eye*/

equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);
T01=T1+V1^2/(2*C_p);
T02/T01=p02_p01^((gama-1)/gama);
eta_ise=(T02-T01)/T02_das_T01;

W_a=C_p*(T02_das_T01);
P=m_adot*W_a;

W_a=phi_w*mu*U2^2;
U2=(pi*D2*N)/60;

(p1*10^5)/rho_a1=R*T1;/*here p1 has been multilied by 10^5 to convert the unit from bar to N/m^2*/
m_adot=rho_a1*(pi/4)*(D1^2-d1^2)*V1;
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_4;
