class Ex3_5
parameter Real pi = Modelica.Constants.pi;
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real m_adot(unit="kg/s")=2;/*free air delivered by the centrifugal compressor*/
parameter Real p1(unit="bar")=1;/*static pressure at inlet*/
parameter Real T1(unit="K")=300;/*static temperature at inlet of impeller vane*/
parameter Real V1(unit="m/s")=75;/*velocity of air at the eye of impeller*/
parameter Real p2(unit="bar")=1.6;/*static pressure at outlet of impeller vane with isentropic condition*/
parameter Real p2_das(unit="bar")=1.6;/*actual static pressure at outlet of impeller vane*/
parameter Real T2_das(unit="K")=350;/*actual static temperature at outlet of impeller vane*/
parameter Real V2(unit="m/s")=210;/*velocity of air at the exit of impeller*/
parameter Real eta_D=0.9;/*diffuser efficiency of the compressor*/

Real T2(unit="K");/*static temperature at outlet of impeller vane with isentropic condition*/

Real W_s(unit="J/kg");/*isentropic work for compressor*/
Real W_a(unit="J/kg");/*actual thermodynamic work required for compressor*/
Real eta_ise(unit="%");/*isentropic efficiency of the compressor*/

Real P(unit="W");/*power required*/
Real T3_das(unit="K");/*actual static temperature at outlet of diffuser*/
Real T3(unit="K");/*static temperature at outlet of diffuser with isentropic condition*/
Real p3(unit="bar");/*static pressure at outlet of diffuser with isentropic condition*/
Real p2_ddas(unit="bar");/*static pressure at outlet of diffuser with isentropic condition*/
Real T2_ddas(unit="K");/*static temperature at outlet of diffuser with isentropic condition*/
Real eta_ise_overall(unit="%");/*overal efficiency*/

equation
T2/T1=(p2/p1)^((gama-1)/gama);

W_s=C_p*(T2-T1)+(V2^2-V1^2)/2;
W_a=C_p*(T2_das-T1)+(V2^2-V1^2)/2;
eta_ise=(W_s/W_a)*100;
P=m_adot*W_a;

C_p*(T3_das-T2_das)=(V2^2-V1^2)/2;
eta_D=(T3-T2_das)/(T3_das-T2_das);

T3/T2_das=(p3/p2_das)^((gama-1)/gama);
p2_ddas=p3;
T2_ddas/T1=(p2_ddas/p1)^((gama-1)/gama);

eta_ise_overall=((T2_ddas-T1)/(T3_das-T1))*100;
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_5;
