class Ex4_4
parameter Real pi = Modelica.Constants.pi;
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/


parameter Real R=0.5;/*degree of reaction*/
parameter Real beta1_deg(unit="deg")=55;/*inlet blade angle in degree unit*/
Real beta1(unit="R");/*inlet blade angle in radian unit*/
parameter Real beta2_deg(unit="deg")=16;/*outlet blade angle in degree unit*/
Real beta2(unit="R");/*outlet blade angle in radian unit*/
parameter Real Dm(unit="m")=0.9;/*mean diameter at center stage*/
parameter Real N(unit="r.p.m.")=5000;/*rotational speed of compressor*/
parameter Real p2_by_p1=1.5;/*static pressure ratio of compression*/
parameter Real T1(unit="K")=300;/*static temperature at inlet*/

Real alpha1(unit="R");/*inlet guide blade angle radian unit*/
Real alpha2(unit="R");/*inlet angle of fixed blade radian unit*/

Real U(unit="m/s");/*mean blade speed*/
Real Vf(unit="m/s");/*velocity of flow*/

Real W_a(unit="J/kg");/*actual work per kg of air*/

Real T2(unit="K");/*static temperature at outlet*/

Real W(unit="J/kg");/*isentopic work per kg of air*/
Real eta_ise(unit="%");/*isentropic stage efficiency in percentage*/

equation
beta1=Modelica.SIunits.Conversions.from_deg(beta1_deg);
beta2=Modelica.SIunits.Conversions.from_deg(beta2_deg);
alpha1=beta2;
alpha2=beta1;

U=(pi*Dm*N)/60;
U/Vf=tan(alpha1)+tan(beta1);

W_a=U*Vf*(tan(beta1)-tan(beta2));

T2/T1=p2_by_p1^((gama-1)/gama);

W=C_p*(T2-T1);

eta_ise=(W_a/W)*100;
/*The  answer may slightly vary due to  rounding off values*/
end Ex4_4;
