class Ex4_7
parameter Real pi = Modelica.Constants.pi;
parameter Real R_gas(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real p0N_by_p01=4;/*overall pressure ratio of compressor*/
parameter Real eta_oise=0.9;/*overall isentropic efficiency*/
parameter Real T01_degC(unit="degC")=25;/*stagnation temperature at inlet in degree Celcius unit*/
Real T01(unit="K");/*stagnation temperature at inlet in degree kelvin unit*/
parameter Real p01(unit="bar")=1;/*stagnation pressure at inlet*/
parameter Real R=0.5;/*degree of reaction*/
parameter Real U(unit="m/s")=190;/*constant mean blade velocity*/
parameter Real beta1_deg(unit="deg")=35;/*inlet blade angle in degree unit*/
Real beta1(unit="R");/*inlet blade angle in radian unit*/
parameter Real beta2_deg(unit="deg")=14;/*outlet blade angle in degree unit*/
Real beta2(unit="R");/*outlet blade angle in radian unit*/

parameter Real omega=0.9;/*work done factor*/

Real alpha1(unit="R");/*inlet guide blade angle*/
Real alpha2(unit="R");/*inlet angle of fixed blade*/

parameter Real Dh_D0=0.4;/*ratio of hub diameter to tip diameter*/
parameter Real m_adot(unit="kg/s")=20;/*mass flow rate*/

Real T0N(unit="K");/*stagnation temperature at last stage with isentropic condition*/
Real T0N_das(unit="K");/*actual stagnation temperature at last stage*/
//Real del_T0_das(unit="K");/*actual stagnation temperature rise in all stage*/
Real eta_p(unit="%");/*polytropic efficiency in percentage*/

Real Vf(unit="m/s");/*axial velocity of flow*/

Real Vw1(unit="m/s");/*velocity of whirl at inlet*/
Real Vw2(unit="m/s");/*velocity of whirl at outlet*/

Real W(unit="J/kg");/*work required per stage per kg of air*/
Real W_t(unit="J/kg");/*total work required per kg of air*/
Real N;/*number of stages*/

Real V1(unit="m/s");/*absolute velocity of air at inlet*/

Real T1(unit="K");/*static temperature at inlet*/
Real p1(unit="bar");/*static pressure at inlet*/
Real rho1(unit="kg/m^3");/*static density of air at inlet*/

Real Dh(unit="m");/*hub diameter*/
Real D0(start=0.01,unit="m");/*tip diameter*/
Real h(unit="m");/*height of blade*/
equation
T01=Modelica.SIunits.Conversions.from_degC(T01_degC);

beta1=Modelica.SIunits.Conversions.from_deg(beta1_deg);
beta2=Modelica.SIunits.Conversions.from_deg(beta2_deg);
alpha1=beta2;
alpha2=beta1;

T0N/T01=p0N_by_p01^((gama-1)/gama);
eta_oise=(T0N-T01)/(T0N_das-T01);

eta_p=((log(p0N_by_p01^((gama-1)/gama)))/(log(T0N_das/T01)))*100;

U/Vf=tan(alpha1)+tan(beta1);

Vw1=Vf*tan(alpha1);
Vw2=Vf*tan(alpha2);

W=U*(Vw2-Vw1);
W_t=C_p*(T0N_das-T01);

N=W_t/W;

V1=Vf/cos(alpha1);/*given value of V1 is wrong*/
T01=T1+V1^2/(2*C_p);

T1/T01=(p1/p01)^((gama-1)/gama);
(p1*10^5)/rho1=R_gas*T1;/*here p1 has been multilied by 10^5 to convert the unit from bar to N/m^2*/

Dh=Dh_D0*D0;
m_adot=rho1*(pi/4)*(D0^2-Dh^2)*Vf;
h=D0/2-Dh/2;

/*The  answer may slightly vary due to  rounding off values*/
end Ex4_7;
