class Ex5_2
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="kJ/kg.K")=1;/*specific heat at constant pressure*/

parameter Real p1(unit="bar")=1;/*pressure at inlet*/
parameter Real T1_degC(unit="degC")=20;/*temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*temperature at inlet in degree kelvin unit*/
parameter Real p2_by_p1=4;/*pressure ratio for process 1-2*/
Real p3_by_p4;/*pressure ratio for process 3-4*/
Real p2(unit="bar");/*pressure at stage 2*/
parameter Real eta_C=0.8;/*isentropic efficiency of compressor*/
parameter Real eta_T=0.9;/*isentropic efficiency of turbine*/
parameter Real m_adot_by_m_fdot=90;/*air fuel ratio*/
parameter Real m_adot(unit="kg/s")=3.2;/*flow rate of air*/
parameter Real C_V(unit="kJ/kg")=41800;/*calorific value of fuel*/

Real T2(unit="K");/*temperature at stage 2 for isentropic condition*/
Real T2_das(unit="K");/*actual temperature at stage 2*/
Real T3(unit="K");/*temperature at stage 3*/
Real T4(unit="K");/*temperature at stage 4 for isentropic condition*/
Real T4_das(unit="K");/*actual temperature at stage 4*/

Real W_T(unit="kJ/kg");/*work developed by turbine per kg of air*/
Real W_C(unit="kJ/kg");/*work of compressor per kg of air*/
Real W_net(unit="kJ/kg");/*work output per kg of air*/
Real P(unit="kW");/*total net power developed by turbine*/
Real Q_s(unit="kJ/kg");/*heat supplied per kg of air*/
Real eta_th(unit="%");/*thermal efficiency of cycle*/
equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);
p2=p2_by_p1*p1;

T2/T1=p2_by_p1^((gama-1)/gama);
eta_C=(T2-T1)/(T2_das-T1);
C_V=(m_adot_by_m_fdot+1)*C_p*(T3-T2_das);

p3_by_p4=p2_by_p1;
T3/T4=p3_by_p4^((gama-1)/gama);
eta_T=(T3-T4_das)/(T3-T4);

W_T=(1+1/m_adot_by_m_fdot)*C_p*(T3-T4_das);

W_C=1*C_p*(T2_das-T1);/*here m_adot=1 kg/s */

W_net=W_T-W_C;
P=m_adot*W_net;
Q_s=(1/m_adot_by_m_fdot)*C_V;
eta_th=(W_net/Q_s)*100;
end Ex5_2;
