class Ex5_6
/*power conversion from MW  to kW- 1 MW=10^3 kW */
parameter Real gama=1.4;/*k=gama=ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real P(unit="kW")=10*10^3;/*power output*/
parameter Real p1(unit="bar")=1;/*pressure at inlet*/
parameter Real T1_degC(unit="degC")=20;/*temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*temperature at inlet in degree kelvin unit*/
parameter Real p2_by_p1=5;/*pressure ratio for process 1-2*/
parameter Real p3_by_p4=5;/*pressure ratio for process 3-4*/
parameter Real T3_degC(unit="degC")=1000;/*temperature at stage 3 in degree Celcius unit*/
Real T3(unit="K");/*temperature at stage 3 in degree kelvin unit*/
parameter Real eta_C=0.8;/*efficiency of compressor*/
parameter Real eta_T=0.9;/*efficiency of turbine*/
parameter Real C_V(unit="kJ/kg")=50000;/*calorific value of fuel*/
parameter Real C_p(unit="kJ/kg.K")=1.01;/*specific heat with constant pressure*/

Real T2(unit="K");/*temperature at stage 2 for isentropic condition*/
Real T2_das(unit="K");/*actual temperature at stage 2*/
Real T4(unit="K");/*temperature at stage 4 for isentropic condition*/
Real T4_das(unit="K");/*actual temperature at stage 4*/

Real m_adot_by_m_fdot;/*air fuel ratio*/

Real W_net(unit="kJ/kg");/*work output per kg of air*/

Real m_adot(unit="kg/s");/*mass flow rate of air*/
Real m_fdot(unit="kg/s");/*fuel flow rate*/

Real P_C(unit="kW");/*power required to drive the compressor*/
Real P_T(unit="kW");/*power developed by turbine*/

Real eta_thermal(unit="%");/*thermal efficiency in percentage*/

equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);
T3=Modelica.SIunits.Conversions.from_degC(T3_degC);

T2/T1=(p2_by_p1)^((gama-1)/gama);
eta_C=(T2-T1)/(T2_das-T1);

T3/T4=(p3_by_p4)^((gama-1)/gama);
eta_T=(T3-T4_das)/(T3-T4);

C_V=(1+m_adot_by_m_fdot)*C_p*(T3-T2_das);

W_net=C_p*((T3-T4_das)-(T2_das-T1));

P=(m_adot+m_fdot)*W_net;
m_adot=m_adot_by_m_fdot*m_fdot;

P_C=m_adot*C_p*(T2_das-T1);
P_T=(m_adot+m_fdot)*C_p*(T3-T4_das);

eta_thermal=(P/(m_fdot*C_V))*100;

/*The  answer may slightly vary due to  rounding off values*/
end Ex5_6;
