class Ex5_7
parameter Real gama=1.4;/*k=gama=ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real T_min_degC(unit="degC")=27;/*minmum temperature*/
Real T_min(unit="K");/*minmum temperature*/
parameter Real T_max_degC(unit="degC")=800;/*maximum temperature*/
Real T_max(unit="K");/*maximum temperature*/
Real r_p_max;/*maximum possible pressure ratio*/
Real r_p_opt;/*pressure ratio at which work done is maximum*/
Real eta_t(unit="%");/*turbine efficiency when work done is maximum */
Real eta_Carnot(unit="%");/*Carnot efficiency*/
Real eta_Brayton_max(unit="%");/*maximum Brayton efficiency*/
equation
T_min=Modelica.SIunits.Conversions.from_degC(T_min_degC);
T_max=Modelica.SIunits.Conversions.from_degC(T_max_degC);

r_p_max=(T_max/T_min)^(gama/(gama-1));
r_p_opt=sqrt(r_p_max);

eta_t=(1-(1/(r_p_opt^((gama-1)/gama))))*100;
eta_Carnot=(1-T_min/T_max)*100;
eta_Brayton_max=(1-(1/(r_p_max^((gama-1)/gama))))*100;
end Ex5_7;
