class Ex6_3
parameter Real pi = Modelica.Constants.pi;
parameter Real gama=1.35;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.15*10^3;/*specific heat at constant pressure*/

parameter Real p1(unit="N/m^2")=7*10^5;/*pressure of flow at inlet of blade*/
parameter Real T1_degC(unit="degC")=300;/*temperature of flow at inlet of blade in degree celcius unit*/
Real T1(unit="K");/*temperature of flow at inlet of blade in Kelvin unit*/
parameter Real p2(unit="N/m^2")=3*10^5;/*pressure of flow at outlet of blade*/
parameter Real alpha_1deg(unit="deg")=20;/*nozzle angle w.r.t. tangential direction in degree unit*/
Real alpha_1(unit="rad");/*nozzle angle w.r.t. tangential direction in radian unit*/
Real sigma;/*optimum blade speed ratio*/
parameter Real W(unit="W")=75*10^3;/*work development rate in blades*/ 
parameter Real eta_N=0.9;/*isentropic efficiency of the nozzle*/

Real T2_das(unit="K");/*isentropic temperature after expansion in the nozzle*/
Real T2(unit="K");/*actual temperature after expansion in the nozzle*/
Real V1(unit="m/s");/*absolute velocity at inlet*/
Real U(unit="m/s");/*blade speed*/
Real beta1(unit="rad");/*rotor balde angle at inlet*/
Real beta2(unit="rad");/*rotor balde angle at outlet*/
Real V_w1(unit="m/s");/*velocity of whirl at entry*/
Real V_f1(unit="m/s");/*velocity of flow of gas at entry*/
Real beta_1das(unit="rad");/*angle of flow at inlet w.r.t. axial direction*/
Real beta_2das(unit="rad");/*angle of flow at outlet w.r.t. axial direction*/
Real V_r1(unit="m/s");/*relative velocity of flow w.r.t. blade at inlet*/
parameter Real K=1;/*velocity coefficient*/
Real V_r2(unit="m/s");/*relative velocity of flow w.r.t. blade at outlet*/
Real V_w2(unit="m/s");/*velocity of whirl at outlet of rotor blade*/
Real m_dot(unit="kg/s");/*mass flow rate*/
equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);
alpha_1=Modelica.SIunits.Conversions.from_deg(alpha_1deg);
sigma=cos(alpha_1)/2;

T2_das/T1=(p2/p1)^((gama-1)/gama);
eta_N=(T1-T2)/(T1-T2_das);
V1=sqrt(2*C_p*(T1-T2));
sigma=U/V1;
V_f1=V1*sin(alpha_1);
V_w1=V1*cos(alpha_1);
tan(beta1)=(V_f1/(V_w1-U));
beta2=beta1;
beta_1das=(pi/2)-beta1;
beta_2das=beta_1das;
V_r1=sqrt(V_f1^2+(V_w1-U)^2);
V_r2=V_r1;
V_w2=V_r2*cos(beta2)-U;
W=m_dot*U*(V_w2+V_w1);
/*the answer in the book for m_dot and Vw2 are wrong*/

end Ex6_3;
