class Ex7_2
parameter Real pi = Modelica.Constants.pi;
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.37;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.147*10^3;/*specific heat at constant pressure*/

parameter Real N(unit="r.p.m")=11000;/*totational speed of turbine*/
parameter Real T01(unit="K")=1000;/*total temperature of flow at inlet of fixed blade*/
parameter Real p01(unit="N/m^2")=5*10^5;/*pressure of flow at inlet of blade  of fixed blade*/
parameter Real p02(unit="N/m^2")=3*10^5;/*exit pressure of the flow of fixed blade*/
parameter Real p03(unit="N/m^2")=1.7*10^5;/*turbine outlet pressure*/
parameter Real alpha1_deg(unit="deg")=22;/*fixed blade outlet angle w.r.t. tangential direction in degree unit*/
Real alpha1(unit="rad");/*fixed blade outlet angle w.r.t. tangential direction in radian unit*/
parameter Real D(unit="m")=70/100;/*blade diameter*/
parameter Real eta_N=95/100;/*isentropic efficiency of the nozzle*/
parameter Real m_dot(unit="kg/s")=25;/*mass flow rate*/
parameter Real eta_m=96/100;/*mechanical efficiency*/
parameter Real M=0.6;/*Mach number of the flow*/

Real T02_das(unit="K");/*isentropic total temperature after expansion in the nozzle*/
Real T02(unit="K");/*actual total temperature after expansion in the nozzle*/

Real V1(unit="m/s");/*velocity of gas at exit of fixed blade*/
Real U(unit="m/s");/*blade velocity*/

Real V_w1(unit="m/s");/*velocity of whirl at entry of rotating blade*/
parameter Real V_w2(unit="m/s")=0;/*velocity of whirl at outlet of rotating blade*/
Real V_f1(unit="m/s");/*velocity of flow of gas at entry of rotating blade*/

Real beta1(unit="rad");/*rotor balde angle at inlet in radian unit*/
Real beta1_deg(unit="deg");/*rotor balde angle at inlet in degree unit*/

Real T3(unit="K");/*temperature at outlet of rotor blade*/

Real V2(unit="m/s");/*velocity of gas at exit of rotor blade*/
Real Vf2(unit="m/s");/*velocity of flow of gas at outlet of rotating blade*/

Real beta2(unit="rad");/*rotor balde angle at outlet*/
Real beta2_deg(unit="deg");/*rotor balde angle at outlet in degree unit*/

Real P_developed(unit="kW");/*developed power*/

equation
alpha1=Modelica.SIunits.Conversions.from_deg(alpha1_deg);

T02_das/T01=(p02/p01)^((gama-1)/gama);
eta_N=(T01-T02)/(T01-T02_das);

V1=sqrt(2*C_p*(T01-T02));
U=(pi*D*N)/60;
V_w1=V1*cos(alpha1);
V_f1=V1*sin(alpha1);

tan(beta1)=(V_f1/(V_w1-U));
beta1_deg=Modelica.SIunits.Conversions.to_deg(beta1);

T3=T02/(p02/p03)^((gama-1)/gama);

V2=M*sqrt(gama*R*T3);
Vf2=V2;

tan(beta2)=V2/U;
beta2_deg=Modelica.SIunits.Conversions.to_deg(beta2);

P_developed=(eta_m*m_dot*(V_w1+V_w2)*U)/1000;
/*The  answer may slightly vary due to  rounding off values*/

end Ex7_2;
