class Ex7_6
parameter Real gama=1.33;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.15*10^3;/*specific heat at constant pressure*/

parameter Real p00(unit="N/m^2")=3.8*10^5;/*inlet total head pressure*/
parameter Real T00(unit="K")=900;/*inlet total head temperature*/
parameter Real p2(unit="N/m^2")=1.3*10^5;/*outlet static pressure*/
parameter Real eta_n=96/100;/*nozzle efficiency*/
parameter Real eta_t_static=88/100;/*static head efficiency*/
parameter Real V2(unit="m/s")=280;/*outlet velocity*/
parameter Real U_root(unit="m/s")=277;/*blade speed at root*/

Real T2_das(unit="K");/*isentropic temperature after expansion in the nozzle*/
Real T2(unit="K");/*actual temperature after expansion in the nozzle*/
Real T02(unit="K");/*actual total temperature after expansion in the nozzle*/
Real W(unit="kW");/*work output*/
equation
T2_das=T00/(p00/p2)^((gama-1)/gama);
eta_t_static=(T00-T2)/(T00-T2_das);
T02=T2+V2^2/(2*C_p);
W=((T00-T02)*C_p)/1000;
/*The  answer may slightly vary due to  rounding off values*/
end Ex7_6;
