class Ex9_1
parameter Real V_a_kmph(unit="kmph")=790;/*speed of the engine in kmph unit*/
Real V_a(unit="m/s");/*speed of the engine in m/s unit*/
parameter Real m_adot(unit="kg/s")=44;/*air flow rate*/
parameter Real m_adot_by_m_fdot=80;/*air to fuel ratio*/
parameter Real  C_V(unit="J/kg")=43500*1000;/*calorific value of fuel*/
parameter Real eta_comb=95/100;/*combustion efficiency*/
parameter Real C_v=0.96;/*velocity coefficient*/
parameter Real dh_ise(unit="J/kg")=188*1000;/*isentropic enthalpy change*/

Real V_j(unit="m/s");/*exit velocity of jet*/
/*for case a*/
Real eta_th_a;/*thermal efficiency*/
Real eta_prop_a;/*propulsive efficiency*/
Real eta_overall_a;/*overall efficiency*/

/*for case b*/
Real eta_th_b;/*thermal efficiency*/
Real eta_prop_b;/*propulsive efficiency*/
Real eta_overall_b;/*overall efficiency*/
equation
V_a=(V_a_kmph*1000)/3600;
V_j=C_v*sqrt(2*dh_ise);
eta_th_a=(((1/2)*(V_j^2-V_a^2))/((1/m_adot_by_m_fdot)*C_V*eta_comb))*100;
eta_prop_a=((2*V_a)/(V_a+V_j))*100;
eta_overall_a=(eta_prop_a/100)*(eta_th_a/100)*100;

eta_th_b=(((1/2)*(m_adot_by_m_fdot+1)*V_j^2-(1/2)*m_adot_by_m_fdot*V_a^2)/(C_V*eta_comb))*100;
eta_prop_b=eta_prop_a;
eta_overall_b=(eta_prop_b/100)*(eta_th_b/100)*100;
/*The  answer may slightly vary due to  rounding off values*/
end Ex9_1;
