class Ex9_5
parameter Real pi = Modelica.Constants.pi;
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/

parameter Real V_a_kmph(unit="kmph")=800;/*speed of the aircraft in kmph unit*/
Real V_a(unit="m/s");/*speed of the aircraft in m/s unit*/
parameter Real eta_prop=50/100;/*propulsive efficiency*/
parameter Real eta_o=18/100;/*overall efficiency*/
parameter Real T(unit="N")=6000;/*total drag on plane*/
parameter Real  C_V(unit="J/kg")=41800*1000;/*calorific value of fuel*/
parameter Real p_a(unit="bar")=0.3;/*ambient pressure*/
parameter Real T_adegC(unit="degC")=-20;/*ambient temperature in degree celcius unit*/
Real T_a(unit="K");/*ambient temperature in kelvin unit*/

Real V_j(unit="m/s");/*exit velocity of jet*/
Real m_adot(unit="kg/s");/*air flow rate*/
Real m_adot_by_m_fdot;/*air to fuel ratio*/
Real rho_a(unit="kg/m^3");/*ambient density*/
Real d(unit="m");/*diameter of jet*/
equation
V_a=(V_a_kmph*1000)/3600;
T_a=Modelica.SIunits.Conversions.from_degC(T_adegC);

eta_prop=((2*V_a)/(V_a+V_j));

T=m_adot*(V_j-V_a);

eta_o=(m_adot_by_m_fdot*(V_j-V_a)*V_a)/C_V;

(p_a*10^5)/rho_a=R*T_a;/*here p_a has been multilied by 10^5 to convert the unit from bar to N/m^2 */

m_adot=rho_a*(pi/4)*d^2*V_j;
/*The  answer may slightly vary due to  rounding off values*/
end Ex9_5;
