class Ex9_7
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real V_a_kmph(unit="kmph")=800;/*speed of the aircraft in kmph unit*/
Real V_a(unit="m/s");/*speed of the aircraft in m/s unit*/
parameter Real C_D=0.02;/*drag coefficient*/
parameter Real A(unit="m^2")=20;/*wing area*/
parameter Real V_j(unit="m/s")=600;/*exit velocity of jet*/

parameter Real p_STP(unit="bar")=1.01325;/*pressure for STP density*/
parameter Real T_STP_degC(unit="degC")=15;/*temperature  for STP density in degree celcius unit*/
Real T_STP(unit="K");/*temperature  for STP density in kelvin unit*/
Real rho_STP(unit="kg/m^3");/*STP density*/
Real rho_a(unit="kg/m^3");/*ambient density*/

Real T(unit="N");/*drag or thrust on wing*/
Real m_adot(unit="kg/s");/*air flow rate*/
Real specefic_thrust(unit="N/kg/s");/*specific thrust*/

equation
V_a=(V_a_kmph*1000)/3600;
T_STP=Modelica.SIunits.Conversions.from_degC(T_STP_degC);

rho_STP=(p_STP*10^5)/(R*T_STP);/*here p_STP has been multilied by 10^5 to convert the unit from bar to N/m^2 */
rho_a=0.5*rho_STP;
T=(1/2)*C_D*rho_a*A*V_a^2;
T=m_adot*(V_j-V_a);
specefic_thrust=T/m_adot;
/*The  answer may slightly vary due to  rounding off values*/
end Ex9_7;
