class Ex9_8
parameter Real gama=1.4;/*k=gama=ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/

parameter Real T1_degC(unit="degC")=20;/*temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*temperature at inlet in degree kelvin unit*/
parameter Real p1(unit="bar")=1;/*pressure at inlet*/
parameter Real p5(unit="bar")=1;/*pressure at at stage 5*/
parameter Real p2(unit="bar")=4;/*pressure at at stage 2*/
parameter Real p3(unit="bar")=4;/*pressure at at stage 3*/

parameter Real eta_C=80/100;/*efficiency of compressor*/
parameter Real eta_T=82/100;/*efficiency of turbine*/
parameter Real T3_degC(unit="degC")=800;/*temperature at stage 3 in degree Celcius unit*/
Real T3(unit="K");/*temperature at stage 3 in degree kelvin unit*/

parameter Real eta_nozzle=90/100;/*nozzle efficiency*/
parameter Real C_V(unit="J/kg")=44000*10^3;/*calorific value of fuel*/
Real C_p(unit="J/kg.K");/*specific heat with constant pressure*/

Real T2(unit="K");/*temperature at stage 2 for isentropic condition*/
Real T2_das(unit="K");/*actual temperature at stage 2*/

Real W_C(unit="J/kg");/*work required to drive the compressor*/
Real Q_s(unit="J/kg");/*energy supplied in combustion chamber during process 2_das-3*/
Real m_adot_by_m_fdot;/*air to fuel ratio*/

Real W_T(unit="J/kg");/*work developed by the turbine*/

Real T4(unit="K");/*temperature at stage 4 for isentropic condition*/
Real T4_das(unit="K");/*actual temperature at stage 4*/
Real p4(unit="bar");/*pressure at at stage 4 for isentropic condition*/
Real p4_das(unit="bar");/*actual pressure at at stage 4*/

Real T5(unit="bar");/*isentropic temperature  at at stage 5*/
Real T5_das(unit="K");/*actual temperature at stage 5*/

parameter Real V_a(unit="m/s")=0;/*velocity of approach*/
Real V_j(unit="m/s");/*exit velocity of jet*/
Real T(unit="N/kg/s");/*thrust per unit mass flow of air*/

equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);
T3=Modelica.SIunits.Conversions.from_degC(T3_degC);
C_p=(gama*R)/(gama-1);

T2/T1=(p2/p1)^((gama-1)/gama);
eta_C=(T2-T1)/(T2_das-T1);

W_C=C_p*(T2_das-T1);
Q_s=C_p*(T3-T2_das);

Q_s*m_adot_by_m_fdot=C_V;
W_T=W_C;

W_T=C_p*(T3-T4_das);
eta_T=(T3-T4_das)/(T3-T4);
T3/T4=(p3/p4)^((gama-1)/gama);
p4_das=p4;

T4_das/T5=(p4_das/p5)^((gama-1)/gama);
eta_nozzle=(T4_das-T5_das)/(T4_das-T5);

V_j=sqrt(2*C_p*(T4_das-T5_das));
T=V_j-V_a;


/*The  answer may slightly vary due to  rounding off values*/

end Ex9_8;
