class Ex1_1
/*area conversion- 1 cm^2=10^(-4) m^2 */
/*pressure conversion- 1 N/cm^2=10^4 N/m^2 */

parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real p_a(unit="N/cm^2")=10;/*atmospheric pressure*/

parameter Real T1_deg(unit="degC")=20;/*temperature at cross section 1 in degree celcius unit*/
Real T1(unit="K");/*temperature at cross section 1 in Kelvin unit*/
parameter Real A1_cm(unit="cm^2")=30;/*area of cross section 1 in centimeter^2 unit*/
Real A1_m(unit="m^2");/*area of cross section 1 in meter^2 unit*/
parameter Real p1_g(unit="N/cm^2")=30;/*gauge pressure at section 1 in N/cm^2 unit*/
Real p1(unit="N/m^2");/*absolute pressure at section 1*/
Real rho1(unit="kg/m^3");/*density of gas at section 1*/
Real V1(unit="m/s",start=1);/*velocity of gas at section 1*/

parameter Real A2_cm(unit="cm^2")=15;/*area of cross section 2 in centimeter^2 unit*/
Real A2_m(unit="m^2");/*area of cross section 2 in meter^2 unit*/
parameter Real p2_g(unit="N/cm^2")=25;/*gauge pressure at section 2 in N/cm^2 unit*/
Real p2(unit="N/m^2");/*absolute pressure at section 2*/
Real rho2(unit="kg/m^3");/*density of gas at section 2*/
Real V2(unit="m/s",start=1);/*velocity of gas at section 2*/
equation
T1=Modelica.SIunits.Conversions.from_degC(T1_deg);
A1_m=A1_cm*10^(-4);
p1=(p1_g+p_a)*10^4;

A2_m=A2_cm*10^(-4);
p2=(p2_g+p_a)*10^4;

rho1*A1_m*V1=rho2*A2_m*V2;

p1/rho1=p2/rho2;

(p1/(rho1*g))*(log(p1)-log(p2))=(V2^2/(2*g))-(V1^2/(2*g));

p1=rho1*R*T1;
/*The  answer may slightly vary due to  rounding off values*/
end Ex1_1;
