class Ex1_3
/*pressure conversion- 1 atm=1.01*10^5 N/m^2 */

parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real rho_m(unit="kg/m^3")=13.6*10^3;/*density of mercury*/
parameter Real h_m(unit="cm")=10;/*height difference of the mercury due to pressure difference*/
Real p1_p2(unit="N/m^2");/*pressure difference*/

parameter Real A2_A1=1/12;/*area ratio of the nozzle*/
parameter Real T1_deg(unit="degC")=27;/*temperature at inlet in degree celcius unit*/
Real T1(unit="K");/*temperature at inlet in Kelvin unit*/
parameter Real p1_atm(unit="atm")=1.2;/*pressure at inlet in atm unit*/
Real p1(unit="N/m^2");/*pressure at inlet in N/m^2 unit*/
Real rho1(unit="kg/m^3");/*density of gas at inlet*/
Real V2(unit="m/s");/*velocity of gas at throat*/
equation
p1_p2=rho_m*g*(h_m/100);/*here h_m has been divided to convert the unit from centimeter to meter*/

T1=Modelica.SIunits.Conversions.from_degC(T1_deg);
p1=p1_atm*1.01*10^5;
rho1=p1/(R*T1);
V2=sqrt((2*p1_p2)/(rho1*(1-A2_A1^2)));
end Ex1_3;
