class Ex10_1
/*pressure conversion from atm to N/m^2 1atm =1.01325*10^5 N/m^2 */

parameter Real R_bar(unit="J/(kg.mol).K")=8314;/*universal gas constant*/
parameter Real M_bar=20;/*molecular weight*/
Real R(unit="J/kg.K");/*specific gas constant*/
parameter Real gama=1.18;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real p_0_atm(unit="atm")=30;/*combustion chamber pressure in atm unit*/
Real p_0(unit="N/m^2");/*combustion chamber pressure in N/m^2 unit*/
parameter Real T_0(unit="K")=3756;/*combustion chamber temperature */
parameter Real A_e(unit="m^2")=15;/*area of rocket nozzle exit*/
parameter Real p_e_atm(unit="atm")=2.4195*10^(-2);/*exit pressure in atm unit*/
Real p_e(unit="N/m^2");/*exit pressure in N/m^2 unit*/

Real I_s(unit="s");/*specefic impulse*/
Real V_e(unit="m/s");/*exit velocity*/
Real T_e(unit="K");/*exit temperature*/
Real rho_e(unit="kg/m^3");/*exit density*/
Real m_dot(unit="kg/s");/*mass flow rate*/
Real T(unit="N");/*thrust*/
Real A_star(unit="m^2");/*throat area*/
Real C_e(unit="m/s");/*speed of sound at exit*/
Real M_e;/*Mach number at exit*/
equation
R=R_bar/M_bar;
p_0=p_0_atm*1.01325*10^5;
p_e=p_e_atm*1.01325*10^5;

I_s=(1/g)*(((2*gama*R*T_0)/(gama-1))*(1-(p_e/p_0)^((gama-1)/gama)))^(1/2);

I_s=V_e/g;

T_e=T_0*(p_e/p_0)^((gama-1)/gama);
rho_e=p_e/(R*T_e);
m_dot=rho_e*A_e*V_e;

T=m_dot*V_e;

m_dot=((p_0*A_star)/sqrt(T_0))*sqrt((gama/R)*(2/(gama+1))^((gama-1)/(gama+1)));

C_e=sqrt(gama*R*T_e);
M_e=V_e/C_e;

/*the answer of A_star which is given in the book is wrong*/
end Ex10_1;
