class Ex10_4
/*pressure conversion from atm to N/m^2 1atm =10^5 N/m^2 */

parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real A_star(unit="m^2")=18*10^(-4);/*throat area*/
parameter Real I_s(unit="s")=128;/*specefic impulse*/
parameter Real p_0_atm(unit="atm")=25;/*combustion chamber pressure in atm unit*/
Real p_0(unit="N/m^2");/*combustion chamber pressure in N/m^2 unit*/
parameter Real W_p(unit="N/s")=44;/*weight flow rate*/
Real T(unit="N");/*thrust*/
Real C_T;/*thrust coefficient*/
Real C_W;/*weight flow coefficient*/
Real SPC(unit="s^(-1)");/*specefic propellant consumption*/
Real V_2star(unit="m/s");/*characteristic velocity*/
equation
p_0=p_0_atm*10^5;

T=I_s*W_p;
C_W=W_p/(p_0*A_star);
C_T=T/(p_0*A_star);
SPC=1/I_s;
V_2star=g/C_W;
/*The  answer may slightly vary due to  rounding off values*/
end Ex10_4;
