class Ex10_5
parameter Real U(unit="m/s")=2800;/*rocket velocity*/
parameter Real V_ej(unit="m/s")=1400;/*effective jet velocity*/
parameter Real m_dot(unit="kg/s")=5;/*propellant flow rate*/
parameter Real QR(unit="J/kg")=6500*10^3;/*heat of reaction of the propellant*/

Real eta_prop(unit="%");/*propulsive efficiency*/
Real eta_th(unit="%");/*thermal efficiency*/
Real eta_o(unit="%");/*overall efficiency*/
equation
eta_prop=((2*(U/V_ej))/(1+(U/V_ej)^2))*100;
eta_th=((V_ej^2+U^2)/(2*QR))*100;
eta_o=((V_ej*U)/QR)*100;
end Ex10_5;
