class Ex2_10
/*velocity conversion 1 m/s=(10^(-3) km)/(3600^(-1)) h =3.6 km/h */

parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real p1(unit="N/m^2")=2.65*10^4;/*static pressure of the air*/
parameter Real p0(unit="N/m^2")=4.24*10^4;/*stagnation pressure measured by pitot tube*/

Real M;/*Mach number of the airplane*/

parameter Real T1(unit="K")=230;/*static temperature of the air*/
Real C(unit="m/s");/*speed of sound*/

Real V(unit="m/s");/*velocity of the airplane*/
Real V_kmph(unit="km/h");/*velocity of aircraft in km/h unit*/
equation
p0=p1*(1+((gama-1)/2)*M^2)^(gama/(gama-1));
C=sqrt(gama*R*T1);
M=V/C;
V_kmph=V*3.6;

/*The  answer may slightly vary due to  rounding off values*/

end Ex2_10;
