class Ex2_11
parameter Real pi = Modelica.Constants.pi;

parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real p0(unit="N/m^2")=150*10^3;/*total pressure of the air inside the tank*/
parameter Real T0_deg(unit="degC")=45;/*total temperature of the air inside the tank in degree celcius unit*/
Real T0(unit="K");/*total temperature of the air inside the tank in in Kelvin unit*/
Real rho0(unit="kg/m^3");/*density of the air inside the tank*/

parameter Real D(unit="cm")=3.5;/*diameter of the nozzle*/ 
Real A1(unit="m^2");/*area of the nozzle*/
parameter Real p1(unit="N/m^2")=101325;/*static pressure at nozzle*/
Real rho1(unit="kg/m^3");/*dencity of the air at nozzle*/


Real V1(unit="m/s");/*velocity of the air at nozzle*/
Real m_dot(unit="kg/s");/*mass flow rate through the nozzle*/

equation
T0=Modelica.SIunits.Conversions.from_degC(T0_deg);
rho0=p0/(R*T0);
V1=sqrt(2*(gama/(gama-1))*(p0/rho0)*(1-(p1/p0)^((gama-1)/gama)));
A1=(pi/4)*(3.5/100)^2;/*here 3.5 has been divided by 100 to change the unit from cm to m*/
rho1/rho0=(p1/p0)^(1/gama);
m_dot=rho1*A1*V1;

/*The  answer may slightly vary due to  rounding off values*/
end Ex2_11;
