class Ex2_14
parameter Real R(unit="J/kg.K")=378;/*specific gas constant*/
parameter Real gama=1.26;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real p0(unit="atm")=20;/*total pressure of the gas inside the combustion chamber*/
parameter Real T0(unit="K")=3000;/*total temperature of the gas inside the combustion chamber*/
Real rho0(unit="kg/m^3");/*density of the gas inside the combustion chamber*/
 
parameter Real A_star(unit="m^2")=0.1;/*area of the nozzle throat*/

parameter Real p_e(unit="atm")=1;/*pressure at nozzle outlet*/
Real T_e(unit="K");/*temperature at nozzle outlet*/

Real C_e(unit="m/s");/*sonic velocity at nozzle exit*/
Real M_e;/*Mach number of the flow at nozzle exit*/
Real V_e(unit="m/s");/*flow velocity at exit*/

Real p_star_p0;/*ratio of pressure at choking condition to total pressure*/
Real p_star(unit="N/m^2");/*pressure of the gas at nozzle throat with choking condition*/

Real T_star_T0;/*ratio of temperature at choking condition to total temperaure*/
Real T_star(unit="K");/*temperature at nozzle throat choking condition*/

Real rho_star_rho0;/*ratio of density at choking condition to total density*/
Real rho_star(unit="kg/m^3");/*temperature at nozzle throat in choking condition*/

Real C_star(unit="m/s");/*sonic velocity at nozzle throat*/
Real V_star(unit="m/s");/*flow velocity at nozzle throat*/ 
Real m_dot(unit="kg/s");/*mass flow rate through the nozzle*/
equation
p_e/p0=(T_e/T0)^(gama/(gama-1));

C_e=sqrt(gama*R*T_e);

T0/T_e=1+((gama-1)/2)*M_e^2;

V_e=M_e*C_e;

p_star_p0=(2/(gama+1))^(gama/(gama-1));
p_star=p_star_p0*(p0*101325);/*here p0 has been multilied by 101325 to change the unit from atm to N/m^2*/

T_star_T0=2/(gama+1);
T_star=T_star_T0*T0;

rho0=(p0*101325)/(R*T0);/*here p0 has been multilied by 101325 to change the unit from atm to N/m^2*/
rho_star_rho0=(2/(gama+1))^(1/(gama-1));
rho_star=rho_star_rho0*rho0;

C_star=sqrt(gama*R*T_star);
V_star=C_star;

m_dot=rho_star*A_star*V_star;
/*The  answer may slightly vary due to  rounding off values*/
end Ex2_14;
