class Ex2_15
/*pressure conversion 1 atm=101325 N/m^2  */

parameter Real R(unit="J/kg.K")=2077;/*specific gas constant*/
parameter Real gama=1.66;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real A(unit="m^2")=3.142*10^(-4);/*area of the nozzle*/

parameter Real p0_atm(unit="atm")=3;/*total pressure inside the container in atm unit*/
Real p0(unit="N/m^2");/*total pressure inside the container in N/m^2*/

parameter Real T0(unit="K")=263;/*total temperature inside the container*/
Real rho0(unit="kg/m^3");/*total density inside the container*/

Real T_star_T0;/*ratio of temperature at critical condition to total temperaure*/
Real T_star(unit="K");/*temperature at critical condition*/

Real C_star(unit="m/s");/*sound velocity at nozzle in critical condition*/
Real V_star(unit="m/s");/*velocity at nozzle with critical condition*/

Real rho_star_rho0;/*ratio of density at critical condition to total density*/
Real rho_star(unit="kg/m^3");/*density at nozzle with critical condition*/

Real m_dot(unit="kg/s");/*mass flow rate through the nozzle*/

Real p_star_p0;/*ratio of pressure at critical condition to total pressure*/
Real p_star(unit="N/m^2");/*pressure at nozzle with critical condition*/

equation
p0=p0_atm*101325;
rho0=p0/(R*T0);

T_star_T0=2/(gama+1);
T_star=T_star_T0*T0;

C_star=sqrt(gama*R*T_star);
V_star=C_star;

rho_star_rho0=(2/(gama+1))^(1/(gama-1));
rho_star=rho_star_rho0*rho0;

m_dot=rho_star*A*V_star;

p_star_p0=(2/(gama+1))^(gama/(gama-1));
p_star=p_star_p0*p0;

/*The  answer may slightly vary due to  rounding off values*/

end Ex2_15;
