class Ex2_16
parameter Real gama=1.26;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real rho1(unit="kg/m^3")=1.26;/*density of the mixture at upstream of the shock*/
parameter Real rho2(unit="kg/m^3")=2.86;/*density of the mixture at downstream of the shock*/

Real M1;/*Mach number of the flow at upstream of the shock*/
Real M2;/*Mach number of the flow at downstream of the shock*/

Real V2_V1;/*velocity ratio of the flow at downstream and upstream of the shock*/

Real p2_p1;/*pressure ratio of the flow at downstream and upstream of the shock*/
equation
rho2/rho1=(M1^2*(gama+1))/(2+M1^2*(gama-1));
M2^2=(2+(gama-1)*M1^2)/(2*gama*M1^2-(gama-1));
V2_V1=1/(rho2/rho1);
p2_p1=(1+gama*M1^2)/(1+gama*M2^2);
/*The  answer may slightly vary due to  rounding off values*/
end Ex2_16;
