class Ex2_17
/*pressure conversion 1 kPa=1000 N/m^2  */

parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real p2_kPa(unit="kPa")=260;/*downstream pressure of the shock in kPa unit*/
Real p2(unit="N/m^2");/*downstream pressure of the shock in N/m^2 unit*/

parameter Real T2_degC(unit="degC")=100;/*downstream temperature of the shock in degree Celcius unit*/
Real T2(unit="K");/*downstream temperature of the shock in degree kelvin unit*/

parameter Real V2(unit="m/s")=160;/*downstream velocity of the shock*/

Real rho2(unit="kg/m^3");/*downstream density of the shock*/

Real C2(unit="m/s");/*downstream sonic velocity of the shock*/
Real M2;/*downstream Mach number of the shock*/

Real M1;/*upstream stream Mach number of the shock*/
Real V1(unit="m/s");/*upstream velocity of the shock*/

Real p1(unit="N/m^2");/*upstream pressure of the shock*/
Real T1(unit="K");/*upstream temperature of the shock*/
Real rho1(unit="kg/m^3");/*upstream density of the shock*/
equation
p2=p2_kPa*1000;

T2=Modelica.SIunits.Conversions.from_degC(T2_degC);
rho2=p2/(R*T2);

C2=sqrt(gama*R*T2);
M2=V2/C2;

M2^2=(2+(gama-1)*M1^2)/(2*gama*M1^2-(gama-1));

p2/p1=(1+gama*M1^2)/(1+gama*M2^2);

V2/V1=((gama-1)*M1^2+2)/((gama+1)*M1^2);

rho1=(rho2*V2)/V1;

T1=p1/(R*rho1);
/*The  answer may slightly vary due to  rounding off values*/
end Ex2_17;
