class Ex2_5
/*area conversion- 1 cm^2=10^(-4) m^2 */

parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real m_dot(unit="kg/s")=0.5;/*mass flow rate through nozzle*/

parameter Real rho1(unit="kg/m^3")=2.23;/*density of air at inlet*/
parameter Real rho2(unit="kg/m^3")=0.174;/*density of air at exit*/

parameter Real T1(unit="K")=833;/*temperature of the air at inlet*/
parameter Real T2(unit="K")=300;/*temperature of the air at exit*/

parameter Real A1_cm(unit="cm^2")=3.87;/*area of inlet in cm^2*/
Real A1(unit="m^2");/*area of inlet in meter^2 unit*/
parameter Real A2_cm(unit="cm^2")=24.2;/*area of exit in cm^2*/
Real A2(unit="m^2");/*area of exit in meter^2 unit*/

Real V1(unit="m/s");/*velocity of gas at inlet*/
Real V2(unit="m/s");/*velocity of gas at exit*/

Real C1(unit="m/s");/*speed of sound at inlet*/
Real C2(unit="m/s");/*speed of sound at exit*/

Real M1;/*Mach number of the flow at inlet*/
Real M2;/*Mach number of the flow at exit*/
equation
A1=A1_cm*10^(-4);
A2=A2_cm*10^(-4);

rho1*A1*V1=m_dot;
rho2*A2*V2=m_dot;

C1=sqrt(gama*R*T1);
C2=sqrt(gama*R*T2);

M1=V1/C1;
M2=V2/C2;

end Ex2_5;
