class Ex2_6
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/

parameter Real A1(unit="m^2")=5;/*area of inlet*/
Real A2(unit="m^2");/*area of exit*/


parameter Real p1(unit="N/m^2")=1.2*10^5;/*pressure of the air at inlet*/
Real p2(unit="N/m^2");/*pressure of the air at exit*/

parameter Real V1(unit="m/s")=10;/*velocity of gas at inlet*/
parameter Real V2(unit="m/s")=30;/*velocity of gas at exit*/

parameter Real T1(unit="K")=330;/*temperature of the air at inlet*/

Real rho(unit="kg/m^3");/*density of air in duct*/

equation
A1*V1=A2*V2;

rho=p1/(R*T1);

p1+(rho*V1^2)/2=p2+(rho*V2^2)/2;

/*The  answer may slightly vary due to  rounding off values*/
end Ex2_6;
