class Ex2_7
/*pressure conversion 1 atm=101325 N/m^2 */

parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real p1_atm(unit="atm")=10;/*pressure of the air at reservior in atm unit*/
Real p1(unit="N/m^2");/*pressure of the air at reservior in N/m^2 unit*/

parameter Real T1_deg(unit="degC")=727;/*temperature of the air at reservior in degree celcius unit*/
Real T1(unit="K");/*temperature of the air at reservior in Kelvin unit*/
parameter Real T_star(unit="K")=830;/*temperature of the air at throat*/
parameter Real T_e(unit="K")=308;/*temperature of the air at exit*/

parameter Real m_dot(unit="kg/s")=0.5;/*mass flow rate through nozzle*/

Real C_p(unit="J/kg.K");/*specific heat at constant pressure*/

parameter Real V1(unit="m/s")=0;/*velocity of gas at reservior*/
Real V_star(unit="m/s");/*velocity of gas at throat*/
Real V_e(unit="m/s");/*velocity of gas at exit*/

Real rho1(unit="kg/m^3");/*density of air at reservior*/
Real rho_star(unit="kg/m^3");/*density of air at throat*/
Real rho_e(unit="kg/m^3");/*density of air at exit*/

Real A_star(unit="m^2");/*area of the throat*/
Real A_e(unit="m^2");/*area of the exit*/

equation
p1=p1_atm*101325;
T1=Modelica.SIunits.Conversions.from_degC(T1_deg);
C_p=(gama*R)/(gama-1);

C_p*T1+(1/2)*V1^2=C_p*T_star+(1/2)*V_star^2;
C_p*T_star+(1/2)*V_star^2=C_p*T_e+(1/2)*V_e^2;

rho1=p1/(R*T1);
rho_star/rho1=(T_star/T1)^(1/(gama-1));
rho_e/rho_star=(T_e/T_star)^(1/(gama-1));

rho_star*A_star*V_star=m_dot;
rho_e*A_e*V_e=m_dot;

/*The  answer may slightly vary due to  rounding off values*/

end Ex2_7;
