class Ex2_8
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real p1(unit="N/m^2")=44069;/*static pressure of the air*/
parameter Real p0(unit="N/m^2")=68000;/*stagnation pressure of the air*/

Real M1;/*Mach number of the airplane*/

parameter Real rho1(unit="kg/m^3")=0.631;/*density of air*/

Real C1(unit="m/s");/*sonic velocity*/
Real V1(unit="m/s");/*velocity of the airplane*/

Real T1(unit="K");/*static temperature of the air*/
Real T0(unit="K");/*total temperature of the air*/
equation
p0=p1*(1+((gama-1)/2)*M1^2)^(gama/(gama-1));
C1=sqrt((gama*p1)/rho1);
M1=V1/C1;

T1=p1/(R*rho1);
T0=T1*(1+((gama-1)/2)*M1^2);
/*The  answer may slightly vary due to  rounding off values*/


end Ex2_8;
