class Ex2_9
/*velocity conversion 1 km/h=1000m/3600s=(1000/3600) m/s */
/*pressure comversion 1kPa=1000*N/m^2 */

parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real V_kmh(unit="km/h")=1200;/*velocity of the airplane kilometer per hour*/
Real V(unit="m/s");/*velocity of the airplane in meter per second*/

parameter Real p1_kPa(unit="kPa")=52;/*static pressure of the air in kPa unit*/
Real p1(unit="N/m^2");/*stagnation pressure of the air in N/m^2 unit*/

parameter Real T1_deg(unit="degC")=-3;/*temperature of the air at reservior in degree celcius unit*/
Real T1(unit="K");/*temperature of the air at reservior in Kelvin unit*/

Real C(unit="m/s");/*velocity of sound*/
Real M;/*Mach number of the airplane*/

Real p0(unit="N/m^2");/*stagnation pressure of the air*/
Real T0(unit="K");/*total temperature of the air*/
Real rho0(unit="kg/m^3");/*stagnation density of air*/

equation
V=V_kmh*(1000/3600);
p1=p1_kPa*1000;
T1=Modelica.SIunits.Conversions.from_degC(T1_deg);
C=sqrt(gama*R*T1);
M=V/C;

p0=p1*(1+((gama-1)/2)*M^2)^(gama/(gama-1));
T0=T1*(1+((gama-1)/2)*M^2);
rho0=p0/(R*T0);

/*The  answer may slightly vary due to  rounding off values*/
end Ex2_9;
