class Ex3_1
/*conversion of rate of mass flow 1 kg/min=(1/60) kg/s */
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real T1_degC(unit="degC")=27;/*static temperature at suction condition in degree Celcius unit*/
Real T1(unit="K");/*static temperature at suction condition in degree kelvin unit*/

parameter Real p1(unit="bar")=1.013;/*static pressure at suction condition*/

parameter Real m_a_kgmin(unit="kg/min")=25;/*free air delivered by the centrifugal compressor in kg/min*/
Real m_a(unit="kg/s");/*free air delivered by the centrifugal compressor in kg/s*/

parameter Real V1(unit="m/s")=50;/*velocity of air at inlet*/
parameter Real eta_ise=0.8;/*isentropic efficiency of the compressor*/
parameter Real p02_p01=4;/*total head pressure ratio of the compressor*/
parameter Real eta_mech=0.95;/*mechanical efficiency*/

Real T01(unit="K");/*total head temperature at inlet*/
Real T02(unit="K");/*total head temperature of air at exit of compressor for isentropic condition*/
Real T02_das(unit="K");/*actual total head temperature of air at exit of compressor*/

Real power(unit="W");/*power required to drive the compressor*/
equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);

T01=T1+V1^2/(2*C_p);
T02/T01=p02_p01^((gama-1)/gama);
eta_ise=(T02_das-T01)/(T02-T01);

m_a=m_a_kgmin/60;
power=(m_a*C_p*(T02_das-T01))/eta_mech;
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_1;
