class Ex3_10
parameter Real pi = Modelica.Constants.pi;
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real D1(unit="m")=0.15;/*inner diameter of impeller*/
parameter Real N(unit="r.p.m")=18000;/*rotational speed of impeller*/
parameter Real V1(unit="m/s")=100;/*absolute velocity at inlet*/
parameter Real Vf1(unit="m/s")=100;/*velocity of flow at inlet of impeller vane*/
parameter Real T01(unit="K")=290;/*total temperature at inlet*/

Real U1(unit="m/s");/*tangential velocity of inpeller vanes at inlet*/

Real beta1_R(unit="R");/*blade angle at inlet in radian unit*/
Real beta1(unit="deg");/*blade angle at inlet in degree unit*/

Real T1(unit="K");/*static temperature at inlet*/

Real C1(unit="m/s");/*velocity of sound at inlet*/
Real Vr1(unit="m/s");/*relative velocity of air w.r.t. tangential velocity of inlet tip of impeller vane*/
Real M;/*Mach number at inlet tip*/
equation
U1=(pi*D1*N)/60;
tan(beta1_R)=Vf1/U1;
beta1=Modelica.SIunits.Conversions.to_deg(beta1_R);
T01=T1+V1^2/(2*C_p);
C1=sqrt(gama*R*T1);
Vr1^2=U1^2+Vf1^2;
M=Vr1/C1;
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_10;
