class Ex3_2
parameter Real pi = Modelica.Constants.pi;
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real N(unit="rpm")=15000;/*rotational speed of the compressor*/
parameter Real m_a(unit="kg/s")=22.5;/*discharge rate*/
parameter Real p1(unit="bar")=1;/*pressure at inlet*/

parameter Real T1_degC(unit="degC")=21;/*static temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*static temperature at inlet in degree kelvin unit*/

parameter Real p2_p1=4;/*static head pressure ratio of the compressor*/

parameter Real eta_ise=0.76;/*isentropic efficiency of the compressor*/
parameter Real mu=0.9;/*slip factor*/
parameter Real phi_w=1.04;/*power input factor*/

Real T2(unit="K");/*static head temperature at outlet for isentropic condition*/
Real T2_das(unit="K");/*actual static head temperature at outlet*/

Real W_a(unit="J/kg");/*actual thermodynamic work required for compressor*/
Real P(unit="W");/*power required*/

Real U2(unit="m/s");/*tangential velocity of inpeller vames at outlet*/
Real D2(unit="m");/*impeller tip diameter*/
equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);

T2/T1=p2_p1^((gama-1)/gama);
eta_ise=(T2-T1)/(T2_das-T1);

W_a=C_p*(T2_das-T1);
P=m_a*W_a;

W_a=phi_w*mu*U2^2;
U2=(pi*D2*N)/60;
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_2;
