class Ex3_6
parameter Real pi = Modelica.Constants.pi;
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real N(unit="rpm")=10000;/*rotational speed of the compressor*/
parameter Real Q_m_min(unit="m^3/min")=600;/*volume flow rate in m^3/min unit*/
Real Q(unit="m^3/s");/*volume flow rate in m^3/s unit*/
parameter Real p1(unit="bar")=1;/*static pressure at inlet*/
parameter Real T1_degC(unit="degC")=27;/*static temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*static temperature at inlet in degree kelvin unit*/
parameter Real p2_p1=3.5;/*static head pressure ratio of the compressor*/
parameter Real eta_ise=0.85;/*isentropic efficiency of the compressor*/
//parameter Real beta2_deg(unit="deg")=90;/*radial tipped vane at outlet in degree unit*/
//parameter Real beta2(unit="R");/*radial tipped vane at outlet in radian unit*/
parameter Real Vf1(unit="m/s")=60;/*velocity of flow at inlet of impeller vane*/
parameter Real Vf2(unit="m/s")=60;/*velocity of flow at outlet of impeller vane*/

Real D1(unit="m");/*inner diameter impeller*/
Real D2(unit="m");/*outer diameter impeller*/

parameter Real mu=0.9;/*slip factor*/
parameter Real phi_w=1;/*power input factor*/
parameter Real K=0.95;/*blade area coefficient at inlet*/
parameter Real eta_mech=0.95;/*mechanical efficiency*/

Real T2(unit="K");/*static temperature at outlet of impeller vane with isentropic condition*/
Real T2_das(unit="K");/*actual static temperature at outlet of impeller vane*/

Real m_adot(unit="kg/s");/*mass flow rate through compressor*/
Real W_a(unit="J/kg");/*actual thermodynamic work required for compressor*/
Real P(unit="W");/*power required*/

Real U1(unit="m/s");/*tangential velocity of inpeller vanes at inlet*/
Real U2(unit="m/s");/*tangential velocity of inpeller vanes at outlet*/


Real A1(unit="m^2");/*actual area available for flow at inlet*/
Real b1(unit="m");/*breadth of impeller at inlet*/

Real beta1(unit="R");/*radial tipped vane at inlet in radian unit*/
Real beta1_deg(unit="deg");/*radial tipped vane at inlet in degree unit*/

Real alpha2_das(unit="R");/*actual diffuser angle at inlet in radian unit*/
Real alpha2_das_deg(unit="deg");/*actual diffuser angle at inlet in degree unit*/

equation
Q=Q_m_min/60;

T1=Modelica.SIunits.Conversions.from_degC(T1_degC);
T2/T1=(p2_p1)^((gama-1)/gama);
eta_ise=(T2-T1)/(T2_das-T1);

(p1*10^5)*Q=m_adot*R*T1;/*here p1 has been multilied by 10^5 to convert the unit from bar to N/m^2*/

W_a=C_p*(T2_das-T1);
P=(m_adot*W_a)/eta_mech;

W_a=phi_w*mu*U2^2;
U2=(pi*D2*N)/60;
D2=1.8*D1;

Q=A1*Vf1;
A1=K*pi*b1*D1;

U1=(pi*D1*N)/60;
tan(beta1)=Vf1/U1;
beta1_deg=Modelica.SIunits.Conversions.to_deg(beta1);

tan(alpha2_das)=Vf2/(mu*U2);
alpha2_das_deg=Modelica.SIunits.Conversions.to_deg(alpha2_das);



/*The  answer may slightly vary due to  rounding off values*/
end Ex3_6;
