class Ex3_7
parameter Real pi = Modelica.Constants.pi;
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real Q1(unit="m^3/s")=5;/*compression rate of air*/
Real Q2(unit="m^3/s");/*discharge rate of flow*/
parameter Real p1(unit="bar")=1;/*static pressure at inlet*/
parameter Real p2(unit="bar")=1.5;/*static pressure at outlet*/
parameter Real T1(unit="K")=300;/*static temperature at inlet*/
Real T2(unit="K");/*static temperature at outlet*/

parameter Real Vf1(unit="m/s")=70;/*velocity of flow at inlet of impeller vane*/
parameter Real Vf2(unit="m/s")=70;/*velocity of flow at outlet of impeller vane*/

parameter Real D1(unit="cm")=30;/*inner diameter of impeller*/
parameter Real D2(unit="cm")=65;/*outer diameter of impeller*/

parameter Real N(unit="rpm")=8000;/*rotational speed of the compressor*/
parameter Real n=1.8;/*polytropic index*/

Real U1(unit="m/s");/*tangential velocity of inpeller vanes at inlet*/
Real U2(unit="m/s");/*tangential velocity of inpeller vanes at outlet*/
Real Vw2(unit="m/s");/*velocity of whirl at outlet of impeller vane*/

Real W_a(unit="J/kg");/*actual thermodynamic work required for compressor*/

Real beta1(unit="R");/*radial tipped vane at inlet in radian unit*/
Real beta1_deg(unit="deg");/*radial tipped vane at inlet in degree unit*/
Real beta2(unit="R");/*radial tipped vane at outlet in radian unit*/
Real beta2_deg(unit="deg");/*radial tipped vane at outlet in degree unit*/
Real alpha2(unit="R");/*diffuser angle at inlet in radian unit*/
Real alpha2_deg(unit="deg");/*diffuser angle at inlet in degree unit*/

parameter Real K=1;/*blade area coefficient at inlet*/
Real b1(unit="m");/*height of impeller vane at inlet*/
Real b2(unit="m");/*height of impeller vane at outlet*/

equation
T2/T1=(p2/p1)^((n-1)/n);
U1=(pi*(D1/100)*N)/60;/*here D1 has been divided by 100 to convert the unit from cm to m*/
U2=(pi*(D2/100)*N)/60;/*here D2 has been divided by 100 to convert the unit from cm to m*/
W_a=C_p*(T2-T1);
W_a=Vw2*U2;

tan(beta1)=Vf1/U1;
beta1_deg=Modelica.SIunits.Conversions.to_deg(beta1);
tan(beta2)=Vf1/(U2-Vw2);
beta2_deg=Modelica.SIunits.Conversions.to_deg(beta2);
tan(alpha2)=Vf2/Vw2;
alpha2_deg=Modelica.SIunits.Conversions.to_deg(alpha2);

Q1=K*pi*b1*(D1/100)*Vf1;/*here D1 has been divided by 100 to convert the unit from cm to m*/
(p1*Q1)/T1=(p2*Q2)/T2;
Q2=K*pi*b2*(D2/100)*Vf2;/*here D2 has been divided by 100 to convert the unit from cm to m*/

/*The  answer may slightly vary due to  rounding off values*/

end Ex3_7;
