class Ex3_8
parameter Real pi = Modelica.Constants.pi;
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real p02_by_p01=4/1;/*total pressure ratio*/
parameter Real D1(unit="m")=0.35;/*diameter of eye of compressor impeller*/
parameter Real m_adot(unit="kg/s")=12;/*mass flow rate of air*/
parameter Real V1(unit="m/s")=130;/*absolute velocity at inlet*/
parameter Real V2(unit="m/s")=115;/*the velocity in the delivery duct*/
parameter Real N(unit="r.p.m")=16000;/*speed of impeller*/
parameter Real eta_ise=0.8;/*total head isentropic efficiency*/
parameter Real phi_p=0.73;/*pressure coefficient*/
parameter Real p01(unit="bar")=1.013;/*ambient total pressure*/
parameter Real T01_degC(unit="degC")=15;/*ambient total temperature in degree celcius*/
Real T01(unit="K");/*ambient total temperature in kelvin*/

Real U1(unit="m/s");/*tangential blade tip speed at inlet*/

Real T1(unit="K");/*static temperature at inlet*/
Real p1(unit="bar");/*static pressure at inlet*/

Real T02(unit="K");/*total temperature at outlet with isentropic condition*/
Real T02_das(unit="K");/*actual total temperature at outlet*/
Real T2_das(unit="K");/*actual static pressure at outlet*/

Real p02(unit="bar");/*total pressure at outlet with isentropic condition*/
Real p02_das(unit="bar");/*actual total pressure at outlet*/
Real p2_das(unit="bar");/*actual static pressure at outlet*/
Real p2_das_by_p1;/*static pressure ratio*/

Real W_a(unit="J/kg");/*thermodynamic work of compressor*/
Real W(unit="J/kg");/*Euler's work of compressor*/
Real theoretical_power(unit="W");/*theoretical power*/

Real beta1(unit="R");/*blade angle at inlet in radian unit*/
Real beta1_deg(unit="deg");/*blade angle at inlet in degree unit*/

equation
U1=(pi*D1*N)/60;

T01=Modelica.SIunits.Conversions.from_degC(T01_degC);
T01=T1+V1^2/(2*C_p);

T01/T1=(p01/p1)^((gama-1)/gama);

T02/T01=p02_by_p01^((gama-1)/gama);
eta_ise=(T02-T01)/(T02_das-T01);
T02_das=T2_das+V2^2/(2*C_p);

p02/p01=p02_by_p01;
p02_das=p02;
T02_das/T2_das=(p02_das/p2_das)^((gama-1)/gama);

p2_das_by_p1=p2_das/p1;

W_a=C_p*(T02_das-T01);
phi_p=W_a/W;
theoretical_power=m_adot*W;

tan(beta1)=V1/U1;
beta1_deg=Modelica.SIunits.Conversions.to_deg(beta1);
/*The  answer may slightly vary due to  rounding off values. Also wrong answer of static pressure ratio is given in the book*/

end Ex3_8;
