class Ex3_9
parameter Real pi = Modelica.Constants.pi;
parameter Real R(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real p2_by_p1=4;/*static pressure ratio*/
parameter Real eta_ise=0.8;/*total head isentropic efficiency*/
parameter Real N(unit="r.p.m")=14000;/*speed of impeller*/
parameter Real T1_degC(unit="degC")=17;/*static temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*static temperature at inlet in degree kelvin unit*/
parameter Real alpha1(unit="deg")=90-20;/*exit angle of inlet guide vane in degree unit*/
Real alpha1_R(unit="R");/*exit angle of inlet guide vane in radian unit*/
parameter Real D1(unit="m")=0.3;/*inner diameter of impeller*/
parameter Real V1(unit="m/s")=140;/*absolute velocity at inlet*/
parameter Real m_adot(unit="kg/s")=12;/*mass flow rate of air*/
parameter Real V2(unit="m/s")=140;/*the velocity in the delivery duct*/
parameter Real D2(unit="m")=0.6;/*outer diameter of impeller*/

Real U1(unit="m/s");/*tangential velocity of inpeller vanes at inlet*/
Real U2(unit="m/s");/*tangential velocity of inpeller vanes at outlet*/

Real T2(unit="K");/*static temperature at outlet with isentropic condition*/
Real T2_das(unit="K");/*actual static temperature at outlet*/

Real W_a(unit="J/kg");/*thermodynamic work of compressor*/

Real Vw1(unit="m/s");/*velocity of whirl at inlet of impeller vane*/
parameter Real phi_w=1;/*work factor*/
Real W(unit="J/kg");/*Euler's work of compressor*/
Real Vw2_das(unit="m/s");/*actual velocity of whirl at outlet of impeller vane*/
Real Vw2(unit="m/s");/*ideal velocity of whirl at outlet of impeller vane*/

Real mu;/*slip factor*/
Real n;/*number of impeller vanes*/
equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);
U1=(pi*D1*N)/60;
U2=(pi*D2*N)/60;

T2/T1=p2_by_p1^((gama-1)/gama);
eta_ise=(T2-T1)/(T2_das-T1);

W_a=C_p*(T2_das-T1);

alpha1_R=Modelica.SIunits.Conversions.from_deg(alpha1);
cos(alpha1_R)=Vw1/V1;
W_a=phi_w*W;
W=Vw2_das*U2-Vw1*U1;
Vw2=U2;
mu=Vw2_das/Vw2;
mu=1-(1.98/n)*(U2/Vw2);
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_9;
