class Ex4_2
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real p0N_by_p01=6;/*overall pressure ratio of compressor*/
parameter Real eta_ise=0.85;/*overall isentropic efficiency*/
parameter Real T01_degC(unit="degC")=20;/*stagnation temperature at inlet in degree Celcius unit*/
Real T01(unit="K");/*stagnation temperature at inlet in degree kelvin unit*/
parameter Real R=0.5;/*degree of reaction*/
parameter Real beta1(unit="deg")=45;/*inlet blade angle in degree unit*/
Real beta1_R(unit="R");/*inlet blade angle in radian unit*/
parameter Real beta2(unit="deg")=15;/*outlet blade angle in degree unit*/
Real beta2_R(unit="R");/*outlet blade angle in radian unit*/
parameter Real U(unit="m/s")=180;/*constant mean blade velocity*/
parameter Real omega=0.88;/*work done factor*/

Real alpha1(unit="R");/*inlet guide blade angle*/
Real alpha2(unit="R");/*inlet angle of fixed blade*/

Real T0N(unit="K");/*stagnation temperature at last stage with isentropic condition*/
Real T0N_das(unit="K");/*actual stagnation temperature at last stage*/
Real del_T0_das(unit="K");/*actual stagnation temperature rise in all stage*/

Real Vf(unit="m/s");/*velocity of flow*/

Real Vw1(unit="m/s");/*velocity of whirl at inlet*/
Real Vw2(unit="m/s");/*velocity of whirl at outlet*/

Real W(unit="J/kg");/*Eulers work per stage*/
Real W_a(unit="J/kg");/*actual work per stage*/

Real d_T0_das(unit="K");/*actual stagnation temperature rise per stage*/ 

Real N;/*number of stage required*/
equation
T01=Modelica.SIunits.Conversions.from_degC(T01_degC);

beta1_R=Modelica.SIunits.Conversions.from_deg(beta1);
beta2_R=Modelica.SIunits.Conversions.from_deg(beta2);
alpha1=beta2_R;
alpha2=beta1_R;

T0N/T01=p0N_by_p01^((gama-1)/gama);
eta_ise=(T0N-T01)/(T0N_das-T01);
del_T0_das=T0N_das-T01;

U=Vf*(tan(beta1_R)+tan(beta2_R));

tan(alpha1)=Vw1/Vf;
tan(alpha2)=Vw2/Vf;

W=U*(Vw2-Vw1);
W_a=omega*W;
W_a=C_p*d_T0_das;

N=del_T0_das/d_T0_das;
/*The  answer may slightly vary due to  rounding off values*/
end Ex4_2;
