class Ex4_3
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real N=8;/*number of stages*/
parameter Real R=0.5;/*degree of reaction*/
parameter Real pN_by_p1=5;/*overall static pressure ratio of compressor*/
parameter Real T1_degC(unit="degC")=25;/*static temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*static temperature at inlet in degree kelvin unit*/
parameter Real Vf(unit="m/s")=100;/*velocity of flow*/
parameter Real U(unit="m/s")=200;/*mean blade velocity*/
parameter Real eta_ise=0.85;/*overall isentropic efficiency*/

Real TN(unit="K");/*static temperature at outlet with isentropic condition*/
Real TN_das(unit="K");/*actual static temperature at outlet*/

Real W_a(unit="J/kg");/*actual work per stage*/


Real alpha1(unit="R");/*inlet guide blade angle radian unit*/
Real alpha1_deg(unit="deg");/*inlet blade angle in degree unit*/
Real alpha2(unit="R");/*inlet angle of fixed blade radian unit*/
Real alpha2_deg(unit="deg");/*outlet blade angle in degree unit*/

Real beta1(unit="R");/*inlet blade angle in radian unit*/
Real beta1_deg(unit="deg");/*inlet blade angle in degree unit*/
Real beta2(unit="R");/*outlet blade angle in radian unit*/
Real beta2_deg(unit="deg");/*outlet blade angle in degree unit*/

equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);

TN/T1=pN_by_p1^((gama-1)/gama);
eta_ise=(TN-T1)/(TN_das-T1);

W_a=C_p*(TN_das-T1);

W_a=N*U*Vf*(tan(alpha2)-tan(alpha1));

alpha1=beta2;
alpha2=beta1;

R=(1/2)*(Vf/U)*(tan(beta1)+tan(beta2));

beta1_deg=Modelica.SIunits.Conversions.to_deg(beta1);
beta2_deg=Modelica.SIunits.Conversions.to_deg(beta2);
alpha1_deg=beta2_deg;
alpha2_deg=beta1_deg;

/*The  answer may slightly vary due to  rounding off values*/
end Ex4_3;
