class Ex4_5
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real eta_ise=0.85;/*overall isentropic efficiency*/
parameter Real T1_degC(unit="degC")=18;/*static temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*static temperature at inlet in degree kelvin unit*/
parameter Real pN_by_p1=4.5;/*overall static pressure ratio of compressor*/
parameter Real R=0.5;/*degree of reaction*/
parameter Real U(unit="m/s")=200;/*constant mean blade speed*/

parameter Real beta1_deg(unit="deg")=42;/*inlet blade angle in degree unit*/
Real beta1(unit="R");/*inlet blade angle in radian unit*/
Real beta2(unit="R");/*outlet blade angle in radian unit*/

parameter Real alpha1_deg(unit="deg")=12;/*inlet guide blade angle in degree unit*/
Real alpha1(unit="R");/*inlet guide blade angle in radian unit*/
Real alpha2(unit="R");/*inlet angle of fixed blade radian unit*/

parameter Real omega=0.85;/*work done factor*/

Real TN(unit="K");/*static temperature at exit with isentropic condition*/
Real TN_das(unit="K");/*actual static temperature at exit*/

Real W_a(unit="J/kg");/*total actual work*/

Real Vf(unit="m/s");/*velocity of flow*/

Real W(unit="J/kg");/*work done per stage*/

Real N;/*number of stages*/

equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);

beta1=Modelica.SIunits.Conversions.from_deg(beta1_deg);
alpha1=Modelica.SIunits.Conversions.from_deg(alpha1_deg);
alpha2=beta1;
beta2=alpha1;

TN/T1=pN_by_p1^((gama-1)/gama);
eta_ise=(TN-T1)/(TN_das-T1);

W_a=C_p*(TN_das-T1);

U/Vf=(tan(alpha1)+tan(beta1));

W=U*Vf*(tan(beta1)-tan(beta2))*omega;

N=W_a/W;
/*given answer for N in the book is wrong*/
end Ex4_5;
