class Ex4_6
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real N=8;/*number of stages*/
parameter Real p0N_by_p01=6;/*overall stagnation pressure ratio of compressor*/
parameter Real eta_oise=0.9;/*overall isentropic efficiency*/
parameter Real T01_degC(unit="degC")=20;/*stagnation temperature at inlet in degree Celcius unit*/
Real T01(unit="K");/*stagnation temperature at inlet in degree kelvin unit*/
parameter Real p01(unit="bar")=1;/*stagnation pressure at inlet*/
parameter Real U(unit="m/s")=150;/*mean blade speed*/
parameter Real R=0.5;/*degree of reaction*/
parameter Real Vf(unit="m/s")=85;/*axial velocity of flow*/


Real T0N(unit="K");/*stagnation temperature at outlet with isentropic condition*/
Real T0N_das(unit="K");/*actual stagnation temperature at outlet*/

Real W(unit="J/kg");/*work required to drive the compressor*/

parameter Real omega=1;/*work done factor*/


Real alpha1(unit="R");/*inlet guide blade angle radian unit*/
Real alpha1_deg(unit="deg");/*inlet blade angle in degree unit*/

Real alpha2_deg(unit="deg");/*outlet blade angle in degree unit*/

Real beta1(unit="R");/*inlet blade angle in radian unit*/
Real beta1_deg(unit="deg");/*inlet blade angle in degree unit*/

Real beta2_deg(unit="deg");/*outlet blade angle in degree unit*/

parameter Real m_adot(unit="kg/s")=1;/*mass flow rate*/
Real P(unit="W");/*power required by compressor*/
equation
T01=Modelica.SIunits.Conversions.from_degC(T01_degC);

T0N/T01=p0N_by_p01^((gama-1)/gama);
eta_oise=(T0N-T01)/(T0N_das-T01);

W=C_p*(T0N_das-T01);

W=N*U*Vf*(tan(beta1)-tan(alpha1))*omega;

(U/Vf)=tan(alpha1)+tan(beta1);

beta1_deg=Modelica.SIunits.Conversions.to_deg(beta1);
alpha1_deg=Modelica.SIunits.Conversions.to_deg(alpha1);
alpha2_deg=beta1_deg;
beta2_deg=alpha1_deg;

P=m_adot*C_p*(T0N_das-T01);

/*The  answer may slightly vary due to  rounding off values and the wrong value of alpha1 is given in the book*/
end Ex4_6;
