class Ex4_8
parameter Real pi = Modelica.Constants.pi;
parameter Real R_gas(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real p1(unit="bar")=1;/*static pressure at inlet*/
parameter Real T01(unit="K")=290;/*stagnation temperature at inlet*/
parameter Real Vf(unit="m/s")=160;/*axial velocity of flow*/
parameter Real Db_D0=0.75;/*ratio of hub diameter to tip diameter*/
parameter Real D0(unit="m")=0.65;/*tip diameter*/
Real Db(unit="m");/*hub diameter*/
Real Dm(unit="m");/*mean diameter*/
parameter Real N(unit="r.p.m.")=95*60;/*speed of compressor. Here 95 has been multilied to convert the unit from rps to rpm*/
parameter Real p2_by_p1=1.2;/*static pressure ratio of compressor*/

Real U(unit="m/s");/*constant mean blade speed*/

Real beta1(unit="R");/*inlet blade angle in radian unit*/
Real beta1_deg(unit="deg");/*inlet blade angle in degree unit*/
parameter Real A_d(unit="R")=(30*pi/180);/*turned angle of air*/
Real beta2(unit="R");/*outlet blade angle in radian unit*/
Real beta2_deg(unit="deg");/*outlet blade angle in degree unit*/

Real T1(unit="K");/*static temperature at inlet*/
Real T2(unit="K");/*static temperature at outlet*/
Real p2(unit="bar");/*static pressure at outlet*/
Real rho2(unit="kg/m^3");/*static density of air at outlet*/

Real m_adot(unit="kg/s");/*mass flow rate*/
parameter Real omega=1;/*work done factor*/
Real P(unit="W");/*power required*/

Real R;/*degree of reaction*/

equation
Db=Db_D0*D0;
Dm=(Db+D0)/2;
U=(pi*Dm*N)/60;

tan(beta1)=U/Vf;
beta1_deg=Modelica.SIunits.Conversions.to_deg(beta1);
beta2=beta1-A_d;
beta2_deg=Modelica.SIunits.Conversions.to_deg(beta2);


T1=T01-Vf^2/(2*C_p);

T2/T1=p2_by_p1^((gama-1)/gama);
p2=p2_by_p1*p1;

(p2*10^5)/rho2=R_gas*T2;/*here p2 has been multilied by 10^5 to convert the unit from bar to N/m^2*/

m_adot=rho2*(pi/4)*(D0^2-Db^2)*Vf;

P=omega*U*Vf*m_adot*(tan(beta1)-tan(beta2));
R=(1/2)*(Vf/U)*(tan(beta1)+tan(beta2));

/*The  answer may slightly vary due to  rounding off values*/
end Ex4_8;
