class Ex4_9
parameter Real pi = Modelica.Constants.pi;
parameter Real R_gas(unit="J/kg.K")=287;/*specific gas constant*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/
parameter Real C_p(unit="J/kg.K")=1.005*10^3;/*specific heat at constant pressure*/

parameter Real m_adot(unit="kg/s")=18;/*mass flow rate*/
parameter Real p01(unit="bar")=1;/*stagnation pressure at inlet*/
parameter Real T01(unit="K")=300;/*stagnation temperature at inlet*/
parameter Real P(unit="W")=4500*10^3;/*consumed power*/
Real T02_das(unit="K");/*actual stagnation temperature of air leaving the first stage*/
parameter Real eta_p=0.9;/*polytropic efficiency*/

Real T0N_das(unit="K");/*actual stagnation temperature at last stage*/
Real n;/*polytropic index*/

Real p0N_das(unit="bar");/*delivery pressure*/
Real p0N(unit="bar");/*stagnation pressure at last stage with isentropic condition*/

Real N;/*number of stages*/
Real p02_by_p01;/*total pressure ratio after 1st stage*/

Real T0N(unit="K");/*stagnation temperature at last stage with isentropic condition*/
Real eta_oise(unit="%");/*overall isentropic efficiency*/

equation
T02_das=T01+20;
P=m_adot*C_p*(T0N_das-T01);
//T0N_das=(P/(m_adot*C_p))+T01;
eta_p=((gama-1)/gama)*(n/(n-1));

p0N_das/p01=(T0N_das/T01)^(n/(n-1));
p0N=p0N_das;

eta_p=(log(p02_by_p01^((gama-1)/gama)))/(log(T02_das/T01));

p0N_das/p01=p02_by_p01^N;

T0N/T01=(p0N/p01)^((gama-1)/gama);
eta_oise=((T0N-T01)/(T0N_das-T01))*100;

/*The  answer may slightly vary due to  rounding off values*/
end Ex4_9;
