class Ex5_1
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume*/

parameter Real r_p=6;/*pressure ratio*/
parameter Real p2_by_p1=6;/*pressure ratio for process 1-2*/
parameter Real p3_by_p4=6;/*pressure ratio for process 3-4*/
parameter Real p1(unit="bar")=1.01325;/*pressure at inlet*/
parameter Real T1_degC(unit="degC")=27;/*temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*temperature at inlet in degree kelvin unit*/
parameter Real T3_degC(unit="degC")=978;/*temperature at stage 3 in degree Celcius unit*/
Real T3(unit="K");/*temperature at stage 3 in degree kelvin unit*/

Real eta_Bryton(unit="%");/*air standard efficiency*/
Real T2(unit="K");/*temperature at stage 2*/
Real T4(unit="K");/*temperature at stage 4*/
Real W_r;/*work ratio*/
equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);
T3=Modelica.SIunits.Conversions.from_degC(T3_degC);
eta_Bryton=(1-(1/r_p^((gama-1)/gama)))*100;
T2/T1=p2_by_p1^((gama-1)/gama);
T3/T4=p3_by_p4^((gama-1)/gama);
W_r=((T3-T4)-(T2-T1))/(T3-T4);

end Ex5_1;
