class Ex5_10
parameter Real p1(unit="bar")=1;/*pressure at inlet*/
Real p2(unit="bar");/*pressure at stage 2*/
parameter Real T1_degC(unit="degC")=17;/*temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*temperature at inlet in degree kelvin unit*/
parameter Real T3_degC(unit="degC")=650;/*temperature at stage 3 in degree Celcius unit*/
Real T3(unit="K");/*temperature at stage 3 in degree kelvin unit*/
parameter Real p2_by_p1=8;/*pressure ratio for process 1-2*/

parameter Real eta_C=80/100;/*isentropic efficiency of compressor*/
parameter Real eta_HPT=85/100;/*isentropic efficiency of high pressure turbine*/
parameter Real eta_LPT=83/100;/*isentropic efficiency of low pressure turbine*/

parameter Real C_pa(unit="kJ/kg.K")=1.005;/*specific heat of air for compression process*/
parameter Real gama_C=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume for compression process*/
parameter Real C_pg(unit="kJ/kg.K")=1.15;/*specific heat of gases for expanssion process*/
parameter Real gama_T=1.333;/*ratio of specific heat at constant pressure and specific heat at constant volume for expanssion process*/

parameter Real m_adot(unit="kg/s")=1;/*mass flow rate*/

Real T2(unit="K");/*temperature at stage 2 for isentropic condition*/
Real T2_das(unit="K");/*actual temperature at stage 2*/

Real W_C(unit="kJ/kg");/*work of compressor per kg of air*/
Real W_HPT(unit="kJ/kg");/*work developed by high pressure turbine per kg of air*/
Real T4_das(unit="K");/*actual temperature at stage 4*/
Real T4(unit="K");/*temperature at stage 4 for isentropic condition*/

Real p3(unit="bar");/*pressure at stage 3*/
Real p4(unit="bar");/*pressure at stage 4 for isentropic condition*/
Real p4_das(unit="bar");/*actual pressure at stage 4*/
Real p5(unit="bar");/*pressure at stage 5*/

Real T5(unit="K");/*temperature at stage 5 for isentropic condition*/
Real T5_das(unit="K");/*actual temperature at stage 5*/
Real W_LPT(unit="kJ/kg");/*work developed by low pressure turbine per kg of air*/
Real W_net(unit="kJ/kg");/*work output per kg of air*/

Real P_shft(unit="kW");/*power available at shaft*/
Real W_R;/*work ratio*/
Real Q_s(unit="kJ/kg");/*heat supply per kg of air*/
Real eta_theramal(unit="%");/*theramal efficiency*/

equation
p2=p2_by_p1*p1;
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);
T3=Modelica.SIunits.Conversions.from_degC(T3_degC);


T2/T1=p2_by_p1^((gama_C-1)/gama_C);
eta_C=(T2-T1)/(T2_das-T1);

W_C=C_pa*(T2_das-T1);
W_HPT=C_pg*(T3-T4_das);
W_C=W_HPT;
eta_HPT=(T3-T4_das)/(T3-T4);

p3=p2;
T3/T4=(p3/p4)^((gama_T-1)/gama_T);
p4_das=p4;
p5=p1;
T4_das/T5=(p4_das/p5)^((gama_T-1)/gama_T);

eta_LPT=(T4_das-T5_das)/(T4_das-T5);

W_LPT=C_pg*(T4_das-T5_das);
W_net=W_LPT;

P_shft=m_adot*W_net;
W_R=W_net/(W_LPT+W_HPT);
Q_s=C_pg*(T3-T2_das);
eta_theramal=(W_net/Q_s)*100;
/*The  answer may slightly vary due to  rounding off values*/

end Ex5_10;
