class Ex5_11
parameter Real p1(unit="bar")=1;/*pressure at inlet*/
parameter Real T1(unit="K")=300;/*temperature at inlet*/
parameter Real p2(unit="bar")=7;/*pressure at stage 2*/
parameter Real p3(unit="bar")=7;/*pressure at stage 3*/
parameter Real p4(unit="bar")=1;/*pressure at stage 4*/
parameter Real m_adot(unit="kg/s")=20;/*mass flow rate of air at compressor*/
parameter Real eta_C=(100-25)/100;/*efficiency of compressor*/
parameter Real eta_mech=95/100;/*mechanical efficiency*/
parameter Real eta_gen=97/100;/*generator efficiency*/
parameter Real C_pg(unit="kJ/kg.K")=1.128;/*specific heat of gases for process 3-4*/
parameter Real gama_34=1.34;/*ratio of specific heat at constant pressure and specific heat at constant volume for process 3-4*/
parameter Real T3_degC(unit="degC")=900;/*temperature at stage 3 in degree Celcius unit*/
Real T3(unit="K");/*temperature at stage 3 in degree kelvin unit*/
parameter Real C_pa(unit="kJ/kg.K")=1.005;/*specific heat of air for process 1-2*/
parameter Real gama_12=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume for process 1-2*/
parameter Real eta_CT=86/100;/*isentropic efficiency of compressor turbine*/
parameter Real eta_PT=86/100;/*isentropic efficiency of power turbine*/

Real T2(unit="K");/*temperature at stage 2 for isentropic condition*/
Real T2_das(unit="K");/*actual temperature at stage 2*/
Real T4(unit="K");/*temperature at stage 4 for isentropic condition*/
Real T4_das(unit="K");/*actual temperature at stage 4*/

Real W_C(unit="kJ/kg");/*work of compression per kg of air supplied*/
Real W_CT(unit="kJ/kg");/*work developed by compression turbine per kg of air*/
Real m(unit="kg/kg");/*air supplied to compressor*/
Real W_PT(unit="kJ/kg");/*work developed by power turbine per kg of air*/
Real W_net(unit="kJ/kg");/*net work*/
Real P(unit="kW");/*total useful output of the plant*/

Real Q_s(unit="kJ/kg");/*heat supply per kg of air supplied to compressor*/
Real Q(unit="kW");/*total heat supplied*/

Real eta_th(unit="%");/*theramal efficiency of the plant*/
Real eta_0(unit="%");/*overall efficiency of the plant*/

equation
T3=Modelica.SIunits.Conversions.from_degC(T3_degC);


T2/T1=(p2/p1)^((gama_12-1)/gama_12);
eta_C=(T2-T1)/(T2_das-T1);

T3/T4=(p3/p4)^((gama_34-1)/gama_34);
eta_CT=(T3-T4_das)/(T3-T4);

W_C=C_pa*(T2_das-T1);
W_CT=W_C;
W_CT=m*C_pg*(T3-T4_das);
W_PT=(1-m)*C_pg*(T3-T4_das);
W_net=W_PT;
P=m_adot*W_net*eta_mech*eta_gen;

Q_s=C_pg*(1-m)*(T3-T2_das)+C_pg*m*(T3-T2_das);
Q=m_adot*Q_s;

eta_th=(W_net/Q_s)*100;
eta_0=(P/Q)*100;


/*The  answer may slightly vary due to  rounding off values*/

end Ex5_11;
