class Ex5_12
parameter Real p1(unit="bar")=1;/*pressure at inlet*/
parameter Real T1_degC(unit="degC")=27;/*temperature at inlet in degree Celcius unit*/
Real T1(unit="K");/*temperature at inlet in degree kelvin unit*/
parameter Real T2_das(unit="K")=490;/*actual temperature at stage 2*/
parameter Real T3(unit="K")=1000;/*temperature at stage 3*/
parameter Real p2_by_p1=5;/*pressure ratio for process 1-2*/
Real p3_by_p4;/*pressure ratio for process 3-4*/
parameter Real eta_T=80/100;/*efficiency of turbine*/
parameter Real epsilon=80/100;/*efficiency of regenerator*/
parameter Real C_p(unit="kJ/kg.K")=1.005;/*specific heat of air*/
parameter Real gama=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume */

Real T4(unit="K");/*temperature at stage 4 for isentropic condition*/
Real T4_das(unit="K");/*actual temperature at stage 4*/
Real T5(unit="K");/*temperature at stage 5 for isentropic condition*/

Real W_C(unit="kJ/kg");/*work of compressor per kg of air*/
Real W_T(unit="kJ/kg");/*work developed by turbine per kg of air*/
Real W_net(unit="kJ/kg");/*net work output per kg of air*/

Real Q_s(unit="kJ/kg");/*heat supplied per kg of air*/
Real Cycle_efficiency(unit="%");/*cycle efficiency*/

equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);

p3_by_p4=p2_by_p1;
T3/T4=p3_by_p4^((gama-1)/gama);
eta_T=(T3-T4_das)/(T3-T4);
epsilon=(T5-T2_das)/(T4_das-T2_das);

W_C=C_p*(T2_das-T1);
W_T=C_p*(T3-T4_das);
W_net=W_T-W_C;

Q_s=C_p*(T3-T5);
Cycle_efficiency=(W_net/Q_s)*100;
/*The  answer may slightly vary due to  rounding off values*/

end Ex5_12;
