class Ex5_13
parameter Real p2_by_p1=4;/*pressure ratio for process 1-2*/
parameter Real eta_C=0.86;/*isentropic efficiency of compressor*/
parameter Real eta_HPT=0.84;/*isentropic efficiency of high pressure turbine*/
parameter Real eta_LPT=0.80;/*isentropic efficiency of low pressure turbine*/
parameter Real eta_mech_drive=0.92;/*mechanical efficiency of drive to compressor*/
parameter Real epsilon=70/100;/*heat exchange effectiveness*/
parameter Real T4_degC(unit="degC")=660;/*temperature at stage 4 in degree cencius*/
Real T4(unit="K");/*temperature at stage 4 in degree kelvin unit*/
parameter Real C_pa(unit="kJ/kg.K")=1.005;/*specific heat of air for process 1-2*/
parameter Real gama_12=1.4;/*ratio of specific heat at constant pressure and specific heat at constant volume for process 1-2*/
parameter Real C_pg(unit="kJ/kg.K")=1.15;/*specific heat of gases for process 3-4*/
parameter Real gama_34=1.333;/*ratio of specific heat at constant pressure and specific heat at constant volume for process 3-4*/
parameter Real p1(unit="bar")=1;/*pressure at inlet*/
parameter Real T1_degC(unit="degC")=15;/*temperature at inlet in degree cencius*/
Real T1(unit="K");/*temperature at inlet in degree kelvin unit*/
parameter Real T6_degC(unit="degC")=625;/*temperature at stage 6 in degree cencius*/
Real T6(unit="K");/*temperature at stage 6 in degree kelvin unit*/

Real p2(unit="bar");/*pressure at stage 2*/
//parameter Real p3(unit="bar")=7;/*pressure at stage 3*/
Real p4(unit="bar");/*pressure at stage 4*/
Real p7(unit="bar");/*pressure at stage 7*/

Real T2(unit="K");/*temperature at stage 2 for isentropic condition*/
Real T2_das(unit="K");/*actual temperature at stage 2*/

Real W_C(unit="kJ/kg");/*work of compression per kg of air supplied*/
Real W_HPT(unit="kJ/kg");/*work developed by high pressure turbine per kg of air*/

Real T5_das(unit="K");/*actual temperature at stage 5*/
Real T5(unit="K");/*temperature at stage 5 for isentropic condition*/
Real p5(unit="bar");/*pressure at stage 5*/
Real p6(unit="bar");/*pressure at stage 6*/

Real T7(unit="K");/*temperature at stage 7 for isentropic condition*/
Real T7_das(unit="K");/*actual temperature at stage 7*/

Real W_LPT(unit="kJ/kg");/*work developed by low pressure turbine per kg of air*/
Real W_net(unit="kJ/kg");/*net work output*/

Real T3(unit="K");/*temperature at stage 3*/
Real Q_s(unit="kJ/kg");/*heat supply per kg of air*/
Real eta_0(unit="%");/*overall efficiency of the plant*/

equation
T1=Modelica.SIunits.Conversions.from_degC(T1_degC);
T4=Modelica.SIunits.Conversions.from_degC(T4_degC);
T6=Modelica.SIunits.Conversions.from_degC(T6_degC);

p2=p2_by_p1*p1;
p4=p2;
p7=p1;

T2/T1=(p2/p1)^((gama_12-1)/gama_12);
eta_C=(T2-T1)/(T2_das-T1);

W_C=C_pa*(T2_das-T1);
W_HPT=W_C/eta_mech_drive;
W_HPT=C_pg*(T4-T5_das);

eta_HPT=(T4-T5_das)/(T4-T5);
T4/T5=(p4/p5)^((gama_34-1)/gama_34);

p6=p5;
T6/T7=(p6/p7)^((gama_34-1)/gama_34);
eta_LPT=(T6-T7_das)/(T6-T7);

W_LPT=C_pg*(T6-T7_das);

W_net=W_LPT;
epsilon=(T3-T2_das)/(T7_das-T2_das);

Q_s=C_pg*((T4-T3)+(T6-T5_das));

eta_0=(W_net/Q_s)*100;


/*The  answer may slightly vary due to  rounding off values and also the answer given in the book is wrong*/

end Ex5_13;
